/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.search_pipeline;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.search_pipeline.RequestProcessor;
import org.opensearch.client.opensearch.search_pipeline.RequestProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NeuralQueryEnricherRequestProcessor
implements RequestProcessorVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, NeuralQueryEnricherRequestProcessor> {
    @Nullable
    private final String defaultModelId;
    @Nullable
    private final String description;
    @Nonnull
    private final Map<String, String> neuralFieldDefaultId;
    @Nullable
    private final String tag;
    public static final JsonpDeserializer<NeuralQueryEnricherRequestProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NeuralQueryEnricherRequestProcessor::setupNeuralQueryEnricherRequestProcessorDeserializer);

    private NeuralQueryEnricherRequestProcessor(Builder builder) {
        this.defaultModelId = builder.defaultModelId;
        this.description = builder.description;
        this.neuralFieldDefaultId = ApiTypeHelper.unmodifiable(builder.neuralFieldDefaultId);
        this.tag = builder.tag;
    }

    public static NeuralQueryEnricherRequestProcessor of(Function<Builder, ObjectBuilder<NeuralQueryEnricherRequestProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public RequestProcessor.Kind _requestProcessorKind() {
        return RequestProcessor.Kind.NeuralQueryEnricher;
    }

    @Nullable
    public final String defaultModelId() {
        return this.defaultModelId;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nonnull
    public final Map<String, String> neuralFieldDefaultId() {
        return this.neuralFieldDefaultId;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.defaultModelId != null) {
            generator.writeKey("default_model_id");
            generator.write(this.defaultModelId);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.neuralFieldDefaultId)) {
            generator.writeKey("neural_field_default_id");
            generator.writeStartObject();
            for (Map.Entry<String, String> item0 : this.neuralFieldDefaultId.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNeuralQueryEnricherRequestProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::defaultModelId, JsonpDeserializer.stringDeserializer(), "default_model_id");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::neuralFieldDefaultId, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "neural_field_default_id");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.defaultModelId);
        result = 31 * result + Objects.hashCode(this.description);
        result = 31 * result + Objects.hashCode(this.neuralFieldDefaultId);
        result = 31 * result + Objects.hashCode(this.tag);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NeuralQueryEnricherRequestProcessor other = (NeuralQueryEnricherRequestProcessor)o;
        return Objects.equals(this.defaultModelId, other.defaultModelId) && Objects.equals(this.description, other.description) && Objects.equals(this.neuralFieldDefaultId, other.neuralFieldDefaultId) && Objects.equals(this.tag, other.tag);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, NeuralQueryEnricherRequestProcessor> {
        @Nullable
        private String defaultModelId;
        @Nullable
        private String description;
        @Nullable
        private Map<String, String> neuralFieldDefaultId;
        @Nullable
        private String tag;

        public Builder() {
        }

        private Builder(NeuralQueryEnricherRequestProcessor o) {
            this.defaultModelId = o.defaultModelId;
            this.description = o.description;
            this.neuralFieldDefaultId = Builder._mapCopy(o.neuralFieldDefaultId);
            this.tag = o.tag;
        }

        private Builder(Builder o) {
            this.defaultModelId = o.defaultModelId;
            this.description = o.description;
            this.neuralFieldDefaultId = Builder._mapCopy(o.neuralFieldDefaultId);
            this.tag = o.tag;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder defaultModelId(@Nullable String value) {
            this.defaultModelId = value;
            return this;
        }

        @Nonnull
        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        @Nonnull
        public final Builder neuralFieldDefaultId(Map<String, String> map) {
            this.neuralFieldDefaultId = Builder._mapPutAll(this.neuralFieldDefaultId, map);
            return this;
        }

        @Nonnull
        public final Builder neuralFieldDefaultId(String key, String value) {
            this.neuralFieldDefaultId = Builder._mapPut(this.neuralFieldDefaultId, key, value);
            return this;
        }

        @Nonnull
        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        @Override
        @Nonnull
        public NeuralQueryEnricherRequestProcessor build() {
            this._checkSingleUse();
            return new NeuralQueryEnricherRequestProcessor(this);
        }
    }
}

