/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.RouteServerRouteInstallationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RouteServerRouteInstallationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RouteServerRouteInstallationDetail> {
    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteTableId").getter(RouteServerRouteInstallationDetail.getter(RouteServerRouteInstallationDetail::routeTableId)).setter(RouteServerRouteInstallationDetail.setter(Builder::routeTableId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").unmarshallLocationName("routeTableId").build()}).build();
    private static final SdkField<String> ROUTE_INSTALLATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteInstallationStatus").getter(RouteServerRouteInstallationDetail.getter(RouteServerRouteInstallationDetail::routeInstallationStatusAsString)).setter(RouteServerRouteInstallationDetail.setter(Builder::routeInstallationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteInstallationStatus").unmarshallLocationName("routeInstallationStatus").build()}).build();
    private static final SdkField<String> ROUTE_INSTALLATION_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RouteInstallationStatusReason").getter(RouteServerRouteInstallationDetail.getter(RouteServerRouteInstallationDetail::routeInstallationStatusReason)).setter(RouteServerRouteInstallationDetail.setter(Builder::routeInstallationStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteInstallationStatusReason").unmarshallLocationName("routeInstallationStatusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_TABLE_ID_FIELD, ROUTE_INSTALLATION_STATUS_FIELD, ROUTE_INSTALLATION_STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RouteServerRouteInstallationDetail.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String routeTableId;
    private final String routeInstallationStatus;
    private final String routeInstallationStatusReason;

    private RouteServerRouteInstallationDetail(BuilderImpl builder) {
        this.routeTableId = builder.routeTableId;
        this.routeInstallationStatus = builder.routeInstallationStatus;
        this.routeInstallationStatusReason = builder.routeInstallationStatusReason;
    }

    public final String routeTableId() {
        return this.routeTableId;
    }

    public final RouteServerRouteInstallationStatus routeInstallationStatus() {
        return RouteServerRouteInstallationStatus.fromValue(this.routeInstallationStatus);
    }

    public final String routeInstallationStatusAsString() {
        return this.routeInstallationStatus;
    }

    public final String routeInstallationStatusReason() {
        return this.routeInstallationStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeInstallationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.routeInstallationStatusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteServerRouteInstallationDetail)) {
            return false;
        }
        RouteServerRouteInstallationDetail other = (RouteServerRouteInstallationDetail)obj;
        return Objects.equals(this.routeTableId(), other.routeTableId()) && Objects.equals(this.routeInstallationStatusAsString(), other.routeInstallationStatusAsString()) && Objects.equals(this.routeInstallationStatusReason(), other.routeInstallationStatusReason());
    }

    public final String toString() {
        return ToString.builder((String)"RouteServerRouteInstallationDetail").add("RouteTableId", (Object)this.routeTableId()).add("RouteInstallationStatus", (Object)this.routeInstallationStatusAsString()).add("RouteInstallationStatusReason", (Object)this.routeInstallationStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RouteTableId": {
                return Optional.ofNullable(clazz.cast(this.routeTableId()));
            }
            case "RouteInstallationStatus": {
                return Optional.ofNullable(clazz.cast(this.routeInstallationStatusAsString()));
            }
            case "RouteInstallationStatusReason": {
                return Optional.ofNullable(clazz.cast(this.routeInstallationStatusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("RouteInstallationStatus", ROUTE_INSTALLATION_STATUS_FIELD);
        map.put("RouteInstallationStatusReason", ROUTE_INSTALLATION_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RouteServerRouteInstallationDetail, T> g) {
        return obj -> g.apply((RouteServerRouteInstallationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String routeTableId;
        private String routeInstallationStatus;
        private String routeInstallationStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteServerRouteInstallationDetail model) {
            this.routeTableId(model.routeTableId);
            this.routeInstallationStatus(model.routeInstallationStatus);
            this.routeInstallationStatusReason(model.routeInstallationStatusReason);
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getRouteInstallationStatus() {
            return this.routeInstallationStatus;
        }

        public final void setRouteInstallationStatus(String routeInstallationStatus) {
            this.routeInstallationStatus = routeInstallationStatus;
        }

        @Override
        public final Builder routeInstallationStatus(String routeInstallationStatus) {
            this.routeInstallationStatus = routeInstallationStatus;
            return this;
        }

        @Override
        public final Builder routeInstallationStatus(RouteServerRouteInstallationStatus routeInstallationStatus) {
            this.routeInstallationStatus(routeInstallationStatus == null ? null : routeInstallationStatus.toString());
            return this;
        }

        public final String getRouteInstallationStatusReason() {
            return this.routeInstallationStatusReason;
        }

        public final void setRouteInstallationStatusReason(String routeInstallationStatusReason) {
            this.routeInstallationStatusReason = routeInstallationStatusReason;
        }

        @Override
        public final Builder routeInstallationStatusReason(String routeInstallationStatusReason) {
            this.routeInstallationStatusReason = routeInstallationStatusReason;
            return this;
        }

        public RouteServerRouteInstallationDetail build() {
            return new RouteServerRouteInstallationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RouteServerRouteInstallationDetail> {
        public Builder routeTableId(String var1);

        public Builder routeInstallationStatus(String var1);

        public Builder routeInstallationStatus(RouteServerRouteInstallationStatus var1);

        public Builder routeInstallationStatusReason(String var1);
    }
}

