/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.function.GaussDBMinMaxFunction;
import org.hibernate.community.dialect.function.GaussDBTruncFunction;
import org.hibernate.community.dialect.function.GaussDBTruncRoundFunction;
import org.hibernate.community.dialect.function.array.GaussDBArrayConcatElementFunction;
import org.hibernate.community.dialect.function.array.GaussDBArrayConcatFunction;
import org.hibernate.community.dialect.function.array.GaussDBArrayConstructorFunction;
import org.hibernate.community.dialect.function.array.GaussDBArrayContainsOperatorFunction;
import org.hibernate.community.dialect.function.array.GaussDBArrayFillFunction;
import org.hibernate.community.dialect.function.array.GaussDBArrayRemoveFunction;
import org.hibernate.community.dialect.function.array.GaussDBArrayRemoveIndexFunction;
import org.hibernate.community.dialect.function.array.GaussDBArrayReplaceFunction;
import org.hibernate.community.dialect.function.array.GaussDBArraySetFunction;
import org.hibernate.community.dialect.function.json.GaussDBJsonObjectFunction;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.array.ArrayIncludesOperatorFunction;
import org.hibernate.dialect.function.array.ArrayIntersectsOperatorFunction;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.type.spi.TypeConfiguration;

public class GaussDBFunctionRegistry {
    private final FunctionContributions functionContributions;
    private final SqmFunctionRegistry functionRegistry;
    private final TypeConfiguration typeConfiguration;

    public GaussDBFunctionRegistry(FunctionContributions functionContributions) {
        this.functionContributions = functionContributions;
        this.functionRegistry = functionContributions.getFunctionRegistry();
        this.typeConfiguration = functionContributions.getTypeConfiguration();
    }

    public void register() {
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(this.functionContributions);
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log();
        functionFactory.mod_operator();
        functionFactory.moreHyperbolic();
        functionFactory.cbrt();
        functionFactory.pi();
        functionFactory.log10_log();
        functionFactory.trim2();
        functionFactory.repeat();
        functionFactory.initcap();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.translate();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.localtimeLocaltimestamp();
        functionFactory.bitLength_pattern("bit_length(?1)", "length(?1)*8");
        functionFactory.octetLength_pattern("octet_length(?1)", "length(?1)");
        functionFactory.ascii();
        functionFactory.char_chr();
        functionFactory.position();
        functionFactory.bitandorxornot_operator();
        functionFactory.bitAndOr();
        functionFactory.everyAny_boolAndOr();
        functionFactory.median_percentileCont(false);
        functionFactory.stddev();
        functionFactory.stddevPopSamp();
        functionFactory.variance();
        functionFactory.varPopSamp();
        functionFactory.covarPopSamp();
        functionFactory.corr();
        functionFactory.regrLinearRegressionAggregates();
        functionFactory.insert_overlay();
        functionFactory.overlay();
        functionFactory.soundex();
        functionFactory.locate_positionSubstring();
        functionFactory.windowFunctions();
        functionFactory.listagg_stringAgg("varchar");
        functionFactory.arrayAggregate();
        functionFactory.arraySlice_operator();
        functionFactory.makeDateTimeTimestamp();
        functionFactory.inverseDistributionOrderedSetAggregates();
        functionFactory.hypotheticalOrderedSetAggregates();
        functionFactory.dateTrunc();
        functionFactory.hex("encode(?1, 'hex')");
        functionFactory.sha("sha256(?1)");
        functionFactory.md5("decode(md5(?1), 'hex')");
        functionFactory.format_toChar();
        this.functionContributions.getFunctionRegistry().register("min", (SqmFunctionDescriptor)new GaussDBMinMaxFunction("min"));
        this.functionContributions.getFunctionRegistry().register("max", (SqmFunctionDescriptor)new GaussDBMinMaxFunction("max"));
        this.functionContributions.getFunctionRegistry().patternDescriptorBuilder("bitxor", "(?1 # ?2)").setExactArgumentCount(2).setArgumentTypeResolver(StandardFunctionArgumentTypeResolvers.ARGUMENT_OR_IMPLIED_RESULT_TYPE).register();
        this.functionContributions.getFunctionRegistry().register("round", (SqmFunctionDescriptor)new GaussDBTruncRoundFunction("round", true));
        this.functionContributions.getFunctionRegistry().register("trunc", (SqmFunctionDescriptor)new GaussDBTruncFunction(true, this.functionContributions.getTypeConfiguration()));
        this.functionContributions.getFunctionRegistry().registerAlternateKey("truncate", "trunc");
        this.array_gaussdb();
        this.arrayRemoveIndex_gaussdb();
        this.arrayConcat_gaussdb();
        this.arrayPrepend_gaussdb();
        this.arrayAppend_gaussdb();
        this.arrayContains_gaussdb();
        this.arrayIntersects_gaussdb();
        this.arrayRemove_gaussdb();
        this.arrayReplace_gaussdb();
        this.arraySet_gaussdb();
        this.arrayFill_gaussdb();
        this.jsonObject_gaussdb();
    }

    public void array_gaussdb() {
        this.functionRegistry.register("array", (SqmFunctionDescriptor)new GaussDBArrayConstructorFunction(false));
        this.functionRegistry.register("array_list", (SqmFunctionDescriptor)new GaussDBArrayConstructorFunction(true));
    }

    public void arrayContains_gaussdb() {
        this.functionRegistry.register("array_contains_nullable", (SqmFunctionDescriptor)new GaussDBArrayContainsOperatorFunction(true, this.typeConfiguration));
        this.functionRegistry.register("array_includes", (SqmFunctionDescriptor)new ArrayIncludesOperatorFunction(false, this.typeConfiguration));
        this.functionRegistry.register("array_includes_nullable", (SqmFunctionDescriptor)new ArrayIncludesOperatorFunction(true, this.typeConfiguration));
    }

    public void arrayIntersects_gaussdb() {
        this.functionRegistry.register("array_intersects", (SqmFunctionDescriptor)new ArrayIntersectsOperatorFunction(false, this.typeConfiguration));
        this.functionRegistry.register("array_intersects_nullable", (SqmFunctionDescriptor)new ArrayIntersectsOperatorFunction(true, this.typeConfiguration));
        this.functionRegistry.registerAlternateKey("array_overlaps", "array_intersects");
        this.functionRegistry.registerAlternateKey("array_overlaps_nullable", "array_intersects_nullable");
    }

    public void arrayConcat_gaussdb() {
        this.functionRegistry.register("array_concat", (SqmFunctionDescriptor)new GaussDBArrayConcatFunction());
    }

    public void arrayPrepend_gaussdb() {
        this.functionRegistry.register("array_prepend", (SqmFunctionDescriptor)new GaussDBArrayConcatElementFunction(true));
    }

    public void arrayAppend_gaussdb() {
        this.functionRegistry.register("array_append", (SqmFunctionDescriptor)new GaussDBArrayConcatElementFunction(false));
    }

    public void arraySet_gaussdb() {
        this.functionRegistry.register("array_set", (SqmFunctionDescriptor)new GaussDBArraySetFunction());
    }

    public void arrayRemove_gaussdb() {
        this.functionRegistry.register("array_remove", (SqmFunctionDescriptor)new GaussDBArrayRemoveFunction());
    }

    public void arrayRemoveIndex_gaussdb() {
        this.functionRegistry.register("array_remove_index", (SqmFunctionDescriptor)new GaussDBArrayRemoveIndexFunction(false));
    }

    public void arrayReplace_gaussdb() {
        this.functionRegistry.register("array_replace", (SqmFunctionDescriptor)new GaussDBArrayReplaceFunction());
    }

    public void arrayFill_gaussdb() {
        this.functionRegistry.register("array_fill", (SqmFunctionDescriptor)new GaussDBArrayFillFunction(false));
        this.functionRegistry.register("array_fill_list", (SqmFunctionDescriptor)new GaussDBArrayFillFunction(true));
    }

    public void jsonObject_gaussdb() {
        this.functionRegistry.register("json_object", (SqmFunctionDescriptor)new GaussDBJsonObjectFunction(this.typeConfiguration));
    }
}

