/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.idea.maven.server.MavenServerStatus;

public final class MavenServerStatsCollector {
    private static final Map<String, AtomicInteger> readCounters = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Map<String, AtomicInteger> pluginResolving = new ConcurrentHashMap<String, AtomicInteger>();
    public static final boolean collectStatistics = Boolean.getBoolean("maven.collect.local.stat");

    private MavenServerStatsCollector() {
    }

    public static void fileRead(File file) {
        if (!collectStatistics) {
            return;
        }
        String path = file.getAbsolutePath();
        MavenServerStatsCollector.putOrAdd(path, readCounters);
    }

    private static void putOrAdd(String path, Map<String, AtomicInteger> countMap) {
        AtomicInteger counter = countMap.get(path);
        if (counter == null) {
            counter = countMap.put(path, new AtomicInteger(1));
        }
        if (counter != null) {
            counter.incrementAndGet();
        }
    }

    private static void fill(Map<String, Integer> dest, Map<String, AtomicInteger> src) {
        src.forEach((key, value) -> dest.put((String)key, value.get()));
    }

    public static void pluginResolve(String mavenid) {
        if (!collectStatistics) {
            return;
        }
        MavenServerStatsCollector.putOrAdd(mavenid, pluginResolving);
    }

    public static void fill(MavenServerStatus status, boolean clean) {
        MavenServerStatsCollector.fill(status.fileReadAccessCount, readCounters);
        MavenServerStatsCollector.fill(status.pluginResolveCount, pluginResolving);
    }
}

