﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace CleanRooms {
namespace Model {
enum class AutoApprovedChangeType { NOT_SET, ADD_MEMBER, GRANT_RECEIVE_RESULTS_ABILITY, REVOKE_RECEIVE_RESULTS_ABILITY };

namespace AutoApprovedChangeTypeMapper {
AWS_CLEANROOMS_API AutoApprovedChangeType GetAutoApprovedChangeTypeForName(const Aws::String& name);

AWS_CLEANROOMS_API Aws::String GetNameForAutoApprovedChangeType(AutoApprovedChangeType value);
}  // namespace AutoApprovedChangeTypeMapper
}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
