# _Run
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-28)</span>

An execution of a property during test mode. i.e. normal execution
to find a sample for which the property does not hold.


```pony
class val _Run is
  Equatable[(_Shrink val | _Run val)] ref
```

#### Implements

* [Equatable](builtin-Equatable.md)\[([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)\] ref

---

## Constructors

### create
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-35)</span>


```pony
new val create(
  round': USize val)
: _Run val^
```
#### Parameters

*   round': [USize](builtin-USize.md) val

#### Returns

* [_Run](pony_check-_Run.md) val^

---

## Public Functions

### round
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-38)</span>


```pony
fun box round()
: USize val
```

#### Returns

* [USize](builtin-USize.md) val

---

### inc
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-40)</span>


```pony
fun box inc()
: (_Shrink val | _Run val)
```

#### Returns

* ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

---

### eq
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-43)</span>


```pony
fun box eq(
  other: (_Shrink val | _Run val))
: Bool val
```
#### Parameters

*   other: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

#### Returns

* [Bool](builtin-Bool.md) val

---

### string
<span class="source-link">[[Source]](src/pony_check/property_runner.md#L-0-50)</span>


```pony
fun box string()
: String iso^
```

#### Returns

* [String](builtin-String.md) iso^

---

### ne
<span class="source-link">[[Source]](src/builtin/compare.md#L-0-20)</span>


```pony
fun box ne(
  that: (_Shrink val | _Run val))
: Bool val
```
#### Parameters

*   that: ([_Shrink](pony_check-_Shrink.md) val | [_Run](pony_check-_Run.md) val)

#### Returns

* [Bool](builtin-Bool.md) val

---

