/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchpipelines.questionanswering.generative.client;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.ml.common.conversation.Interaction;
import org.opensearch.ml.memory.action.conversation.CreateConversationAction;
import org.opensearch.ml.memory.action.conversation.CreateConversationRequest;
import org.opensearch.ml.memory.action.conversation.CreateConversationResponse;
import org.opensearch.ml.memory.action.conversation.CreateInteractionAction;
import org.opensearch.ml.memory.action.conversation.CreateInteractionRequest;
import org.opensearch.ml.memory.action.conversation.CreateInteractionResponse;
import org.opensearch.ml.memory.action.conversation.GetInteractionsAction;
import org.opensearch.ml.memory.action.conversation.GetInteractionsRequest;
import org.opensearch.ml.memory.action.conversation.GetInteractionsResponse;
import org.opensearch.transport.client.Client;

public class ConversationalMemoryClient {
    @Generated
    private static final Logger log = LogManager.getLogger(ConversationalMemoryClient.class);
    private static final Logger logger = LogManager.getLogger();
    private static final long DEFAULT_TIMEOUT_IN_MILLIS = 10000L;
    private Client client;

    public String createConversation(String name) {
        CreateConversationResponse response = (CreateConversationResponse)this.client.execute((ActionType)CreateConversationAction.INSTANCE, (ActionRequest)new CreateConversationRequest(name)).actionGet(10000L);
        log.info("createConversation: id: {}", (Object)response.getId());
        return response.getId();
    }

    public String createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo) {
        Preconditions.checkNotNull((Object)conversationId);
        Preconditions.checkNotNull((Object)input);
        Preconditions.checkNotNull((Object)response);
        CreateInteractionResponse res = (CreateInteractionResponse)this.client.execute((ActionType)CreateInteractionAction.INSTANCE, (ActionRequest)new CreateInteractionRequest(conversationId, input, promptTemplate, response, origin, additionalInfo)).actionGet(10000L);
        log.info("createInteraction: interactionId: {}", (Object)res.getId());
        return res.getId();
    }

    public void createInteraction(String conversationId, String input, String promptTemplate, String response, String origin, Map<String, String> additionalInfo, final ActionListener<String> listener) {
        this.client.execute((ActionType)CreateInteractionAction.INSTANCE, (ActionRequest)new CreateInteractionRequest(conversationId, input, promptTemplate, response, origin, additionalInfo), (ActionListener)new ActionListener<CreateInteractionResponse>(){

            public void onResponse(CreateInteractionResponse createInteractionResponse) {
                listener.onResponse((Object)createInteractionResponse.getId());
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    public List<Interaction> getInteractions(String conversationId, int lastN) {
        Preconditions.checkArgument((lastN > 0 ? 1 : 0) != 0, (Object)"lastN must be at least 1.");
        log.info("In getInteractions, conversationId {}, lastN {}", (Object)conversationId, (Object)lastN);
        ArrayList<Interaction> interactions = new ArrayList<Interaction>();
        int from = 0;
        boolean allInteractionsFetched = false;
        int maxResults = lastN;
        do {
            GetInteractionsResponse response;
            List list;
            if ((list = (response = (GetInteractionsResponse)this.client.execute((ActionType)GetInteractionsAction.INSTANCE, (ActionRequest)new GetInteractionsRequest(conversationId, maxResults, from)).actionGet(10000L)).getInteractions()) != null && !CollectionUtils.isEmpty((Collection)list)) {
                interactions.addAll(list);
                from += list.size();
                maxResults -= list.size();
            } else if (response.hasMorePages()) break;
            boolean bl = allInteractionsFetched = !response.hasMorePages();
        } while (from < lastN && !allInteractionsFetched);
        return interactions;
    }

    public void getInteractions(String conversationId, int lastN, final ActionListener<List<Interaction>> listener) {
        this.client.execute((ActionType)GetInteractionsAction.INSTANCE, (ActionRequest)new GetInteractionsRequest(conversationId, lastN, 0), (ActionListener)new ActionListener<GetInteractionsResponse>(){

            public void onResponse(GetInteractionsResponse getInteractionsResponse) {
                listener.onResponse((Object)getInteractionsResponse.getInteractions());
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    @Generated
    public ConversationalMemoryClient(Client client) {
        this.client = client;
    }
}

