/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.decommission;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;

@PublicApi(since="2.4.0")
public final class DecommissionAttribute
implements Writeable {
    private final String attributeName;
    private final String attributeValue;

    public DecommissionAttribute(String attributeName, String attributeValue) {
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
    }

    public String attributeName() {
        return this.attributeName;
    }

    public String attributeValue() {
        return this.attributeValue;
    }

    public DecommissionAttribute(StreamInput in) throws IOException {
        this.attributeName = in.readString();
        this.attributeValue = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.attributeName);
        out.writeString(this.attributeValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecommissionAttribute that = (DecommissionAttribute)o;
        if (!this.attributeName.equals(that.attributeName)) {
            return false;
        }
        return this.attributeValue.equals(that.attributeValue);
    }

    public int hashCode() {
        return Objects.hash(this.attributeName, this.attributeValue);
    }

    public String toString() {
        return "DecommissionAttribute{attributeName='" + this.attributeName + "', attributeValue='" + this.attributeValue + "'}";
    }
}

