/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.repulsion;

import java.util.Map;
import java.util.Random;
import org.jungrapht.visualization.layout.algorithms.repulsion.BarnesHutRepulsion;
import org.jungrapht.visualization.layout.algorithms.repulsion.StandardFRRepulsion;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.quadtree.BarnesHutQuadTree;
import org.jungrapht.visualization.layout.quadtree.ForceObject;

public class BarnesHutFRRepulsion<V>
extends StandardFRRepulsion<V, BarnesHutFRRepulsion<V>, Builder<V>>
implements BarnesHutRepulsion<V, BarnesHutFRRepulsion<V>, Builder<V>> {
    protected double EPSILON = 1.0E-6;
    private BarnesHutQuadTree<V> tree;

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static Builder barnesHutBuilder() {
        return BarnesHutFRRepulsion.builder();
    }

    protected BarnesHutFRRepulsion(Builder<V> builder) {
        super(builder);
        this.tree = builder.tree;
    }

    @Override
    public void step() {
        this.tree.rebuild(this.vertexSet, this.layoutModel);
    }

    @Override
    public void calculateRepulsion() {
        for (Object vertex : this.vertexSet) {
            Point forcePoint = (Point)this.layoutModel.apply(vertex);
            ForceObject nodeForceObject = new ForceObject(vertex, forcePoint.x, forcePoint.y){

                protected void addForceFrom(ForceObject other) {
                    double dx = this.p.x - other.p.x;
                    double dy = this.p.y - other.p.y;
                    double dist = Math.sqrt(dx * dx + dy * dy);
                    dist = Math.max(BarnesHutFRRepulsion.this.EPSILON, dist);
                    double force = BarnesHutFRRepulsion.this.repulsionSquared / dist;
                    this.f = this.f.add(force * (dx / dist), force * (dy / dist));
                }
            };
            this.tree.applyForcesTo(nodeForceObject);
            this.frVertexData.put(vertex, Point.of(nodeForceObject.f.x, nodeForceObject.f.y));
        }
    }

    public static class Builder<V>
    extends StandardFRRepulsion.Builder<V, BarnesHutFRRepulsion<V>, Builder<V>>
    implements BarnesHutRepulsion.Builder<V, BarnesHutFRRepulsion<V>, Builder<V>> {
        private double theta = 0.5;
        private BarnesHutQuadTree<V> tree;

        @Override
        public Builder<V> layoutModel(LayoutModel<V> layoutModel) {
            this.layoutModel = layoutModel;
            this.tree = BarnesHutQuadTree.builder().bounds(layoutModel.getWidth(), layoutModel.getHeight()).theta(this.theta).build();
            return this;
        }

        @Override
        public Builder<V> theta(double theta) {
            this.theta = theta;
            return this;
        }

        @Override
        public Builder<V> nodeData(Map<V, Point> frVertexData) {
            this.frVertexData = frVertexData;
            return this;
        }

        @Override
        public Builder<V> repulsionConstant(double repulstionConstant) {
            this.repulsionConstant = repulstionConstant;
            return this;
        }

        @Override
        public Builder<V> random(Random random) {
            this.random = random;
            return this;
        }

        @Override
        public BarnesHutFRRepulsion<V> build() {
            return new BarnesHutFRRepulsion(this);
        }
    }
}

