/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class FloatingPointTextField
extends JTextField {
    private Double minValue = Double.NEGATIVE_INFINITY;
    private Double maxValue = Double.POSITIVE_INFINITY;

    public FloatingPointTextField(int columns) {
        super(columns);
        AbstractDocument doc = (AbstractDocument)this.getDocument();
        doc.setDocumentFilter(new FloatingPointDocumentFilter());
    }

    public FloatingPointTextField(int columns, double initialValue) {
        this(columns);
        this.setValue(initialValue);
    }

    public double getValue() {
        return this.parseDouble(this.getText());
    }

    public void setValue(double value) {
        this.setText(Double.toString(value));
    }

    public void setMaxValue(double max) {
        if (max < 0.0) {
            throw new IllegalArgumentException("Max value can not be negative!");
        }
        this.maxValue = max;
    }

    public void setMinValue(double min) {
        if (min > 0.0) {
            throw new IllegalArgumentException("Min value can not be positive!");
        }
        this.minValue = min;
    }

    private double parseDouble(String text) {
        if (text.equals("")) {
            text = "0";
        } else if (text.equals("-")) {
            text = "-0";
        } else if (text.equals(".")) {
            text = "0";
        } else if (text.equals("-.")) {
            text = "-0";
        }
        return Double.parseDouble(text);
    }

    private class FloatingPointDocumentFilter
    extends DocumentFilter {
        private static final String FLOATING_POINT_REGEX = "-?[0-9]*\\.?[0-9]*";

        private FloatingPointDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            text = text.trim();
            StringBuilder builder = this.getText(fb);
            builder.insert(offset, text);
            if (this.isValid(builder)) {
                super.insertString(fb, offset, text, attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            text = text.trim();
            StringBuilder builder = this.getText(fb);
            builder.replace(offset, offset + length, text);
            if (this.isValid(builder)) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            StringBuilder builder = this.getText(fb);
            builder.delete(offset, offset + length);
            if (this.isValid(builder)) {
                super.remove(fb, offset, length);
            }
        }

        private boolean isValid(StringBuilder builder) {
            if (builder.isEmpty()) {
                return true;
            }
            String value = builder.toString();
            if (!value.matches(FLOATING_POINT_REGEX)) {
                return false;
            }
            double d = FloatingPointTextField.this.parseDouble(value);
            if (FloatingPointTextField.this.minValue.compareTo(d) > 0) {
                return false;
            }
            return FloatingPointTextField.this.maxValue.compareTo(d) >= 0;
        }

        private StringBuilder getText(DocumentFilter.FilterBypass fb) throws BadLocationException {
            StringBuilder builder = new StringBuilder();
            Document document = fb.getDocument();
            builder.append(document.getText(0, document.getLength()));
            return builder;
        }
    }
}

