/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.menu.DockingMenuUI;
import docking.menu.ManagedMenuItem;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.MenuItemManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuListener;

public class MenuManager
implements ManagedMenuItem {
    private static String NULL_GROUP_NAME = "<null group>";
    private Set<ManagedMenuItem> managedMenuItems = new HashSet<ManagedMenuItem>();
    private Map<String, MenuManager> subMenus = new HashMap<String, MenuManager>();
    private String name;
    private final String[] menuPath;
    private char mnemonicKey = '\u0000';
    private int level;
    private boolean usePopupPath;
    private MenuHandler menuHandler;
    private String group;
    private JPopupMenu popupMenu;
    private JMenu menu;
    private MenuGroupMap menuGroupMap;
    private Comparator<ManagedMenuItem> comparator;

    public MenuManager(String name, char mnemonicKey, String group, boolean usePopupPath, MenuHandler menuHandler, MenuGroupMap menuGroupMap) {
        this(name, new String[]{name}, mnemonicKey, 0, group, usePopupPath, menuHandler, menuGroupMap);
    }

    MenuManager(String name, String[] menuPath, char mnemonicKey, int level, String group, boolean usePopupPath, MenuHandler menuHandler, MenuGroupMap menuGroupMap) {
        this.name = name;
        this.menuPath = menuPath;
        this.mnemonicKey = mnemonicKey;
        this.level = level;
        this.menuGroupMap = menuGroupMap;
        if (menuGroupMap == null) {
            this.menuGroupMap = new MenuGroupMap();
        }
        this.group = group;
        this.usePopupPath = usePopupPath;
        this.menuHandler = menuHandler;
        this.comparator = usePopupPath ? new ManagedMenuItemComparator(this, new PopupGroupComparator(this)) : new ManagedMenuItemComparator(this, new GroupComparator(this));
    }

    public void addAction(DockingActionIf action) {
        MenuData menuData;
        this.checkForSwingThread();
        this.resetMenus();
        MenuData menuData2 = menuData = this.usePopupPath ? action.getPopupMenuData() : action.getMenuBarData();
        if (this.isSubMenu(menuData)) {
            MenuManager mgr = this.getSubMenu(menuData);
            mgr.addAction(action);
        } else {
            this.managedMenuItems.add(new MenuItemManager(this.menuHandler, action, this.usePopupPath));
        }
    }

    private boolean isSubMenu(MenuData menuData) {
        String[] actionMenuPath = menuData.getMenuPath();
        return actionMenuPath.length > this.level + 1;
    }

    private MenuManager getSubMenu(MenuData menuData) {
        String[] fullPath = menuData.getMenuPath();
        String displayName = fullPath[this.level];
        char mnemonic = MenuManager.getMnemonicKey(displayName);
        String realName = MenuManager.stripMnemonicAmp(displayName);
        MenuManager subMenu = this.subMenus.get(realName);
        if (subMenu != null) {
            return subMenu;
        }
        int subMenuLevel = this.level + 1;
        String[] subMenuPath = new String[subMenuLevel];
        System.arraycopy(fullPath, 0, subMenuPath, 0, subMenuLevel);
        String subMenuGroup = this.getSubMenuGroup(menuData, realName, subMenuPath);
        subMenu = new MenuManager(realName, subMenuPath, mnemonic, subMenuLevel, subMenuGroup, this.usePopupPath, this.menuHandler, this.menuGroupMap);
        this.subMenus.put(realName, subMenu);
        this.managedMenuItems.add(subMenu);
        return subMenu;
    }

    private String getSubMenuGroup(MenuData menuData, String menuName, String[] subMenuPath) {
        String pullRightGroup = this.getPullRightMenuGroup(menuData);
        if (pullRightGroup != null) {
            return pullRightGroup;
        }
        pullRightGroup = this.menuGroupMap.getMenuGroup(subMenuPath);
        if (pullRightGroup != null) {
            return pullRightGroup;
        }
        return menuName;
    }

    private String getPullRightMenuGroup(MenuData menuData) {
        boolean isParentOfLeaf;
        String[] actionMenuPath = menuData.getMenuPath();
        int leafLevel = actionMenuPath.length - 1;
        boolean bl = isParentOfLeaf = this.level == leafLevel - 1;
        if (!isParentOfLeaf) {
            return null;
        }
        return menuData.getParentMenuGroup();
    }

    public DockingActionIf getAction(String actionName) {
        for (ManagedMenuItem item : this.managedMenuItems) {
            DockingActionIf action;
            if (!(item instanceof MenuItemManager) || !actionName.equals((action = ((MenuItemManager)item).getAction()).getName())) continue;
            return action;
        }
        return null;
    }

    public static char getMnemonicKey(String str) {
        int ampLoc = str.indexOf(38);
        char mk = '\u0000';
        if (ampLoc >= 0 && ampLoc < str.length() - 1) {
            mk = str.charAt(ampLoc + 1);
        }
        return mk;
    }

    public static String stripMnemonicAmp(String text) {
        int ampLoc = text.indexOf(38);
        if (ampLoc < 0) {
            return text;
        }
        Object s = text.substring(0, ampLoc);
        if (ampLoc < text.length() - 1) {
            s = (String)s + text.substring(++ampLoc);
        }
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.managedMenuItems.isEmpty();
    }

    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JMenu(this.name);
            if (this.mnemonicKey != '\u0000') {
                this.menu.setMnemonic(this.mnemonicKey);
            }
            if (this.menuHandler != null) {
                this.menu.addMenuListener(this.menuHandler);
            }
            ArrayList<ManagedMenuItem> list = new ArrayList<ManagedMenuItem>(this.managedMenuItems);
            Collections.sort(list, this.comparator);
            String lastGroup = null;
            for (ManagedMenuItem item : list) {
                if (lastGroup != null && !lastGroup.equals(item.getGroup())) {
                    this.menu.addSeparator();
                }
                lastGroup = item.getGroup();
                this.menu.add(item.getMenuItem());
            }
        }
        return this.menu;
    }

    @Override
    public JMenuItem getMenuItem() {
        JMenu localMenu = this.getMenu();
        localMenu.setUI(DockingMenuUI.createUI(localMenu));
        return localMenu;
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public String getSubGroup() {
        String menuSubGroup = this.menuGroupMap.getMenuSubGroup(this.menuPath);
        if (menuSubGroup == null) {
            return MenuData.NO_SUBGROUP;
        }
        return menuSubGroup;
    }

    @Override
    public void dispose() {
        for (ManagedMenuItem item : this.managedMenuItems) {
            item.dispose();
        }
        this.subMenus.clear();
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu(this.name);
            ArrayList<ManagedMenuItem> list = new ArrayList<ManagedMenuItem>(this.managedMenuItems);
            Collections.sort(list, this.comparator);
            String lastGroup = NULL_GROUP_NAME;
            boolean hasMenuItems = false;
            for (ManagedMenuItem item : list) {
                String itemGroup = item.getGroup();
                if (itemGroup == null) {
                    itemGroup = NULL_GROUP_NAME;
                }
                if (!lastGroup.equals(itemGroup) && hasMenuItems) {
                    this.popupMenu.addSeparator();
                }
                if ((lastGroup = item.getGroup()) == null) {
                    lastGroup = NULL_GROUP_NAME;
                }
                this.popupMenu.add(item.getMenuItem());
                hasMenuItems = true;
            }
        }
        return this.popupMenu;
    }

    private void remove(ManagedMenuItem item) {
        this.managedMenuItems.remove(item);
        if (item instanceof MenuManager) {
            this.subMenus.remove(((MenuManager)item).name);
        }
        item.dispose();
    }

    @Override
    public boolean removeAction(DockingActionIf action) {
        for (ManagedMenuItem item : this.managedMenuItems) {
            if (!item.removeAction(action)) continue;
            if (item.isEmpty()) {
                this.remove(item);
            }
            this.resetMenus();
            return true;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    private void resetMenus() {
        this.popupMenu = null;
        this.menu = null;
    }

    public void menuGroupChanged(String[] theMenuPath, int i, String localGroup) {
        this.checkForSwingThread();
        this.resetMenus();
    }

    private void checkForSwingThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("Calls to MenuManager must be in the Swing Thread!");
        }
    }

    public PopupMenuListener getMenuHandler() {
        return this.menuHandler;
    }

    @Override
    public String getMenuItemText() {
        return this.name;
    }

    private class ManagedMenuItemComparator
    implements Comparator<ManagedMenuItem> {
        private final Comparator<String> groupComparator;

        ManagedMenuItemComparator(MenuManager menuManager, Comparator<String> groupComparator) {
            this.groupComparator = groupComparator;
        }

        @Override
        public int compare(ManagedMenuItem m1, ManagedMenuItem m2) {
            String text2;
            String subGroup2;
            int result = this.groupComparator.compare(m1.getGroup(), m2.getGroup());
            if (result != 0) {
                return result;
            }
            String subGroup1 = m1.getSubGroup();
            result = subGroup1.compareTo(subGroup2 = m2.getSubGroup());
            if (result != 0) {
                return result;
            }
            String text1 = m1.getMenuItemText();
            result = text1.compareTo(text2 = m2.getMenuItemText());
            if (result == 0) {
                return System.identityHashCode(m1) - System.identityHashCode(m2);
            }
            return result;
        }
    }

    private class PopupGroupComparator
    implements Comparator<String> {
        private PopupGroupComparator(MenuManager menuManager) {
        }

        @Override
        public int compare(String group1, String group2) {
            if (group1 == null && group2 == null) {
                return 0;
            }
            if (group1 == null) {
                return -1;
            }
            if (group2 == null) {
                return 1;
            }
            return group1.compareTo(group2);
        }
    }

    private class GroupComparator
    implements Comparator<String> {
        private GroupComparator(MenuManager menuManager) {
        }

        @Override
        public int compare(String group1, String group2) {
            if (group1 == null && group2 == null) {
                return 0;
            }
            if (group1 == null) {
                return 1;
            }
            if (group2 == null) {
                return -1;
            }
            return group1.compareTo(group2);
        }
    }
}

