/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

public enum SectionKind {
    Code(0, true),
    UnpackedData(1, true),
    PackedData(2, true),
    Constant(3, true),
    Loader(4, false),
    Debug(5, false),
    ExecutableData(6, true),
    Exception(7, false),
    Traceback(8, false);

    private int value;
    private boolean instantiated;

    private SectionKind(int value, boolean instantiated) {
        this.value = value;
        this.instantiated = instantiated;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isInstantiated() {
        return this.instantiated;
    }

    public static SectionKind get(int value) {
        SectionKind[] kinds;
        for (SectionKind kind : kinds = SectionKind.values()) {
            if (kind.value != value) continue;
            return kind;
        }
        throw new IllegalArgumentException();
    }
}

