/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class MapItem
implements StructConverter {
    private short type;
    private short unused;
    private int size;
    private int offset;

    public MapItem(BinaryReader reader) throws IOException {
        this.type = reader.readNextShort();
        this.unused = reader.readNextShort();
        this.size = reader.readNextInt();
        this.offset = reader.readNextInt();
    }

    public short getType() {
        return this.type;
    }

    public short getUnused() {
        return this.unused;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffset() {
        return this.offset;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(MapItem.class);
        dataType.setCategoryPath(new CategoryPath("/dex"));
        return dataType;
    }
}

