/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Cursor;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;

class DragActionDetector {
    DragActionDetector() {
    }

    static DragActionResult detectDragAction(DragGestureEvent dge) {
        int dragActionType = dge.getDragAction();
        Cursor cursor = DragActionDetector.getCursorByAction(dragActionType);
        if ((dge.getTriggerEvent().getModifiersEx() & 0x800) != 0) {
            cursor = DragSource.DefaultCopyDrop;
            dragActionType = 1;
        } else if (DragActionDetector.isLinkDragEvent(dge)) {
            cursor = DragSource.DefaultLinkDrop;
            dragActionType = 0x40000000;
        }
        return new DragActionResult(dragActionType, cursor);
    }

    private static boolean isLinkDragEvent(DragGestureEvent e) {
        return (e.getTriggerEvent().getModifiersEx() & 0x1000) != 0;
    }

    private static Cursor getCursorByAction(int dragAction) {
        switch (dragAction) {
            case 1: {
                return DragSource.DefaultCopyDrop;
            }
            case 0x40000000: {
                return DragSource.DefaultLinkDrop;
            }
        }
        return DragSource.DefaultMoveDrop;
    }

    static class DragActionResult {
        final int dragAction;
        final Cursor cursor;

        private DragActionResult(int dragAction, Cursor cursor) {
            this.dragAction = dragAction;
            this.cursor = cursor;
        }
    }
}

