/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.runtime;

import java.io.IOException;
import java.io.InputStream;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class ProgressStreamReader
extends InputStream {
    static final int BUFFER_SIZE = 10000;
    private final DBRProgressMonitor monitor;
    private final InputStream original;
    private final long streamLength;
    private long totalRead;

    public ProgressStreamReader(DBRProgressMonitor monitor, String task, InputStream original, long streamLength) {
        this.monitor = monitor;
        this.original = original;
        this.streamLength = streamLength;
        this.totalRead = 0L;
        monitor.beginTask(task, (int)streamLength);
    }

    @Override
    public int read() throws IOException {
        int res = this.original.read();
        this.showProgress(res);
        return res;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int res = this.original.read(b);
        this.showProgress(res);
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = this.original.read(b, off, len);
        this.showProgress(res);
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        long res = this.original.skip(n);
        this.showProgress(res);
        return res;
    }

    @Override
    public int available() throws IOException {
        return this.original.available();
    }

    @Override
    public void close() throws IOException {
        this.monitor.done();
        this.original.close();
    }

    private void showProgress(long length) {
        this.totalRead += length;
        this.monitor.worked((int)length);
    }
}

