/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ElementValue;

public class ElementValuesEditor {
    private final ProgramClass targetClass;
    private final Annotation targetAnnotation;
    private final ArrayElementValue targetArrayElementValue;
    private final boolean replaceElementValues;

    public ElementValuesEditor(ProgramClass targetClass, Annotation targetAnnotation, boolean replaceElementValues) {
        this.targetClass = targetClass;
        this.targetAnnotation = targetAnnotation;
        this.targetArrayElementValue = null;
        this.replaceElementValues = replaceElementValues;
    }

    public ElementValuesEditor(ProgramClass targetClass, ArrayElementValue targetArrayElementValue, boolean replaceElementValues) {
        this.targetClass = targetClass;
        this.targetAnnotation = null;
        this.targetArrayElementValue = targetArrayElementValue;
        this.replaceElementValues = replaceElementValues;
    }

    public void addElementValue(ElementValue elementValue) {
        if (this.targetAnnotation != null) {
            if (!this.replaceElementValues || !this.replaceElementValue(this.targetAnnotation.u2elementValuesCount, this.targetAnnotation.elementValues, elementValue)) {
                this.targetAnnotation.elementValues = this.addElementValue(this.targetAnnotation.u2elementValuesCount, this.targetAnnotation.elementValues, elementValue);
                ++this.targetAnnotation.u2elementValuesCount;
            }
        } else if (!this.replaceElementValues || !this.replaceElementValue(this.targetArrayElementValue.u2elementValuesCount, this.targetArrayElementValue.elementValues, elementValue)) {
            this.targetArrayElementValue.elementValues = this.addElementValue(this.targetArrayElementValue.u2elementValuesCount, this.targetArrayElementValue.elementValues, elementValue);
            ++this.targetArrayElementValue.u2elementValuesCount;
        }
    }

    public void deleteElementValue(String elementValueMethodName) {
        if (this.targetAnnotation != null) {
            this.targetAnnotation.u2elementValuesCount = this.deleteElementValue(this.targetAnnotation.u2elementValuesCount, this.targetAnnotation.elementValues, elementValueMethodName);
        } else {
            this.targetArrayElementValue.u2elementValuesCount = this.deleteElementValue(this.targetArrayElementValue.u2elementValuesCount, this.targetArrayElementValue.elementValues, elementValueMethodName);
        }
    }

    private boolean replaceElementValue(int elementValuesCount, ElementValue[] elementValues, ElementValue elementValue) {
        int index = this.findElementValue(elementValuesCount, elementValues, elementValue.getMethodName(this.targetClass));
        if (index < 0) {
            return false;
        }
        elementValues[index] = elementValue;
        return true;
    }

    private ElementValue[] addElementValue(int elementValuesCount, ElementValue[] elementValues, ElementValue elementValue) {
        if (elementValues.length <= elementValuesCount) {
            ElementValue[] newElementValues = new ElementValue[elementValuesCount + 1];
            System.arraycopy(elementValues, 0, newElementValues, 0, elementValuesCount);
            elementValues = newElementValues;
        }
        elementValues[elementValuesCount] = elementValue;
        return elementValues;
    }

    private int deleteElementValue(int elementValuesCount, ElementValue[] elementValues, String elementValueMethodName) {
        int index = this.findElementValue(elementValuesCount, elementValues, elementValueMethodName);
        if (index < 0) {
            return elementValuesCount;
        }
        System.arraycopy(elementValues, index + 1, elementValues, index, elementValuesCount - index - 1);
        elementValues[--elementValuesCount] = null;
        return elementValuesCount;
    }

    private int findElementValue(int elementValuesCount, ElementValue[] elementValues, String elementValueName) {
        for (int index = 0; index < elementValuesCount; ++index) {
            if (!elementValues[index].getMethodName(this.targetClass).equals(elementValueName)) continue;
            return index;
        }
        return -1;
    }
}

