#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
module: organizations_saml
short_description: Resource module for organizations _saml
description:
  - Manage operation update of the resource organizations _saml.
  - Updates the SAML SSO enabled settings for an organization.
version_added: '1.0.0'
extends_documentation_fragment:
  - cisco.meraki.module
author: Francisco Munoz (@fmunoz)
options:
  enabled:
    description: Boolean for updating SAML SSO enabled settings.
    type: bool
  organizationId:
    description: OrganizationId path parameter. Organization ID.
    type: str
  spInitiated:
    description: SP-Initiated SSO settings.
    suboptions:
      idpId:
        description: SAML IdP ID for SP-Initiated SSO Authentication.
        type: str
      subdomain:
        description: Organization's unique SSO identifier.
        type: str
    type: dict
requirements:
  - meraki >= 2.4.9
  - python >= 3.5
seealso:
  - name: Cisco Meraki documentation for organizations updateOrganizationSaml
    description: Complete reference of the updateOrganizationSaml API.
    link: https://developer.cisco.com/meraki/api-v1/#!update-organization-saml
notes:
  - SDK Method used are
    organizations.Organizations.update_organization_saml,
  - Paths used are
    put /organizations/{organizationId}/saml,
"""

EXAMPLES = r"""
- name: Update all
  cisco.meraki.organizations_saml:
    meraki_api_key: "{{ meraki_api_key }}"
    meraki_base_url: "{{ meraki_base_url }}"
    meraki_single_request_timeout: "{{ meraki_single_request_timeout }}"
    meraki_certificate_path: "{{ meraki_certificate_path }}"
    meraki_requests_proxy: "{{ meraki_requests_proxy }}"
    meraki_wait_on_rate_limit: "{{ meraki_wait_on_rate_limit }}"
    meraki_nginx_429_retry_wait_time: "{{ meraki_nginx_429_retry_wait_time }}"
    meraki_action_batch_retry_wait_time: "{{ meraki_action_batch_retry_wait_time }}"
    meraki_retry_4xx_error: "{{ meraki_retry_4xx_error }}"
    meraki_retry_4xx_error_wait_time: "{{ meraki_retry_4xx_error_wait_time }}"
    meraki_maximum_retries: "{{ meraki_maximum_retries }}"
    meraki_output_log: "{{ meraki_output_log }}"
    meraki_log_file_prefix: "{{ meraki_log_file_prefix }}"
    meraki_log_path: "{{ meraki_log_path }}"
    meraki_print_console: "{{ meraki_print_console }}"
    meraki_suppress_logging: "{{ meraki_suppress_logging }}"
    meraki_simulate: "{{ meraki_simulate }}"
    meraki_be_geo_id: "{{ meraki_be_geo_id }}"
    meraki_caller: "{{ meraki_caller }}"
    meraki_use_iterator_for_get_pages: "{{ meraki_use_iterator_for_get_pages }}"
    meraki_inherit_logging_config: "{{ meraki_inherit_logging_config }}"
    state: present
    enabled: true
    organizationId: string
    spInitiated:
      idpId: uu3H_bx28Nnd
      subdomain: example_subdomain
"""
RETURN = r"""
meraki_response:
  description: A dictionary or list with the response returned by the Cisco Meraki Python SDK
  returned: always
  type: dict
  sample: >
    {
      "enabled": true,
      "spInitiated": {
        "subdomain": "string",
        "idpId": "string"
      }
    }
"""
