/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.initialization.ConventionInterfaceGenerator;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classpath.transforms.CommonTypes;
import org.objectweb.asm.ClassWriter;

public class DefaultLegacyTypesSupport
implements LegacyTypesSupport {
    private static final int JAVA_BYTE_CODE_COMPATIBILITY = 52;
    private static final int INTERFACE_ACCESS_MODIFIERS = 5633;
    private final ConventionInterfaceGenerator conventionGenerator = new ConventionInterfaceGenerator();
    private final Set<String> classesToMixInGroovyObject = this.readClassNames("converted-types.txt");
    private final Set<String> syntheticClasses = this.getRemovedClassNames();

    private Set<String> getRemovedClassNames() {
        Set<String> removedClassNames = this.readClassNames("removed-types.txt");
        removedClassNames.addAll(this.conventionGenerator.getRemovedClassNames());
        return removedClassNames;
    }

    @Override
    public Set<String> getClassesToMixInGroovyObject() {
        return this.classesToMixInGroovyObject;
    }

    @Override
    public Set<String> getSyntheticClasses() {
        return this.syntheticClasses;
    }

    private Set<String> readClassNames(String resourceName) {
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        URL resource = LegacyTypesSupport.class.getResource(resourceName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                classNames.add(line.trim());
            }
        }
        catch (IOException e) {
            throw new GradleException("Could not load class names from '" + resource + "'.", (Throwable)e);
        }
        return classNames;
    }

    @Override
    public byte[] generateSyntheticClass(String name) {
        if (this.conventionGenerator.isConventionClass(name)) {
            return this.conventionGenerator.generateConventionClass(name);
        }
        return DefaultLegacyTypesSupport.generateEmptyInterface(name);
    }

    private static byte[] generateEmptyInterface(String name) {
        ClassWriter visitor = new ClassWriter(0);
        visitor.visit(52, 5633, DefaultLegacyTypesSupport.getInternalName(name), null, CommonTypes.OBJECT_TYPE.getInternalName(), null);
        visitor.visitEnd();
        return visitor.toByteArray();
    }

    private static String getInternalName(String className) {
        return className.replace('.', '/');
    }

    @Override
    public void injectEmptyInterfacesIntoClassLoader(ClassLoader classLoader) {
        try {
            for (String name : this.syntheticClasses) {
                byte[] bytes = this.generateSyntheticClass(name);
                ClassLoaderUtils.define((ClassLoader)classLoader, (String)name, (byte[])bytes);
            }
        }
        catch (Exception e) {
            throw new GradleException("Could not inject synthetic classes.", (Throwable)e);
        }
    }
}

