/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group.interceptors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ErrorHandler;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptorMBean;
import org.apache.catalina.tribes.util.ExecutorFactory;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.catalina.tribes.util.TcclThreadFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MessageDispatchInterceptor
extends ChannelInterceptorBase
implements MessageDispatchInterceptorMBean {
    private static final Log log = LogFactory.getLog(MessageDispatchInterceptor.class);
    protected static final StringManager sm = StringManager.getManager(MessageDispatchInterceptor.class);
    protected long maxQueueSize = 0x4000000L;
    protected volatile boolean run = false;
    protected boolean useDeepClone = true;
    protected boolean alwaysSend = true;
    protected final AtomicLong currentSize = new AtomicLong(0L);
    protected ExecutorService executor = null;
    protected int maxThreads = 10;
    protected int maxSpareThreads = 2;
    protected long keepAliveTime = 5000L;

    public MessageDispatchInterceptor() {
        this.setOptionFlag(8);
    }

    @Override
    public void sendMessage(Member[] memberArray, ChannelMessage channelMessage, InterceptorPayload interceptorPayload) throws ChannelException {
        boolean bl;
        boolean bl2 = bl = (channelMessage.getOptions() & 8) == 8;
        if (bl && this.run) {
            if (this.getCurrentSize() + (long)channelMessage.getMessage().getLength() > this.maxQueueSize) {
                if (this.alwaysSend) {
                    super.sendMessage(memberArray, channelMessage, interceptorPayload);
                    return;
                }
                throw new ChannelException(sm.getString("messageDispatchInterceptor.queue.full", Long.toString(this.maxQueueSize), Long.toString(this.getCurrentSize())));
            }
            if (this.useDeepClone) {
                channelMessage = (ChannelMessage)channelMessage.deepclone();
            }
            if (!this.addToQueue(channelMessage, memberArray, interceptorPayload)) {
                throw new ChannelException(sm.getString("messageDispatchInterceptor.unableAdd.queue"));
            }
            this.addAndGetCurrentSize(channelMessage.getMessage().getLength());
        } else {
            super.sendMessage(memberArray, channelMessage, interceptorPayload);
        }
    }

    public boolean addToQueue(ChannelMessage channelMessage, Member[] memberArray, InterceptorPayload interceptorPayload) {
        this.executor.execute(() -> this.sendAsyncData(channelMessage, memberArray, interceptorPayload));
        return true;
    }

    public void startQueue() {
        if (this.run) {
            return;
        }
        Object object = "";
        if (this.getChannel().getName() != null) {
            object = "[" + this.getChannel().getName() + "]";
        }
        this.executor = ExecutorFactory.newThreadPool(this.maxSpareThreads, this.maxThreads, this.keepAliveTime, TimeUnit.MILLISECONDS, new TcclThreadFactory("MessageDispatchInterceptor.MessageDispatchThread" + (String)object));
        this.run = true;
    }

    public void stopQueue() {
        this.run = false;
        this.executor.shutdownNow();
        this.setAndGetCurrentSize(0L);
    }

    @Override
    public void setOptionFlag(int n) {
        if (n != 8) {
            log.warn((Object)sm.getString("messageDispatchInterceptor.warning.optionflag"));
        }
        super.setOptionFlag(n);
    }

    public void setMaxQueueSize(long l) {
        this.maxQueueSize = l;
    }

    public void setUseDeepClone(boolean bl) {
        this.useDeepClone = bl;
    }

    @Override
    public long getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public boolean getUseDeepClone() {
        return this.useDeepClone;
    }

    @Override
    public long getCurrentSize() {
        return this.currentSize.get();
    }

    public long addAndGetCurrentSize(long l) {
        return this.currentSize.addAndGet(l);
    }

    public long setAndGetCurrentSize(long l) {
        this.currentSize.set(l);
        return l;
    }

    @Override
    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    @Override
    public int getMaxSpareThreads() {
        return this.maxSpareThreads;
    }

    @Override
    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setKeepAliveTime(long l) {
        this.keepAliveTime = l;
    }

    public void setMaxSpareThreads(int n) {
        this.maxSpareThreads = n;
    }

    public void setMaxThreads(int n) {
        this.maxThreads = n;
    }

    @Override
    public boolean isAlwaysSend() {
        return this.alwaysSend;
    }

    @Override
    public void setAlwaysSend(boolean bl) {
        this.alwaysSend = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(int n) throws ChannelException {
        if (!this.run) {
            MessageDispatchInterceptor messageDispatchInterceptor = this;
            synchronized (messageDispatchInterceptor) {
                if (!this.run && (n & 2) == 2) {
                    this.startQueue();
                }
            }
        }
        super.start(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(int n) throws ChannelException {
        if (this.run) {
            MessageDispatchInterceptor messageDispatchInterceptor = this;
            synchronized (messageDispatchInterceptor) {
                if (this.run && (n & 2) == 2) {
                    this.stopQueue();
                }
            }
        }
        super.stop(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAsyncData(ChannelMessage channelMessage, Member[] memberArray, InterceptorPayload interceptorPayload) {
        ErrorHandler errorHandler = null;
        if (interceptorPayload != null) {
            errorHandler = interceptorPayload.getErrorHandler();
        }
        try {
            super.sendMessage(memberArray, channelMessage, null);
            try {
                if (errorHandler != null) {
                    errorHandler.handleCompletion(new UniqueId(channelMessage.getUniqueId()));
                }
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("messageDispatchInterceptor.completeMessage.failed"), (Throwable)exception);
            }
        }
        catch (Exception exception) {
            ChannelException channelException = exception instanceof ChannelException ? (ChannelException)exception : new ChannelException(exception);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("messageDispatchInterceptor.AsyncMessage.failed"), (Throwable)exception);
            }
            try {
                if (errorHandler != null) {
                    errorHandler.handleError(channelException, new UniqueId(channelMessage.getUniqueId()));
                }
            }
            catch (Exception exception2) {
                log.error((Object)sm.getString("messageDispatchInterceptor.errorMessage.failed"), (Throwable)exception2);
            }
        }
        finally {
            this.addAndGetCurrentSize(-channelMessage.getMessage().getLength());
        }
    }

    @Override
    public int getPoolSize() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getPoolSize();
        }
        return -1;
    }

    @Override
    public int getActiveCount() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getActiveCount();
        }
        return -1;
    }

    @Override
    public long getTaskCount() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getTaskCount();
        }
        return -1L;
    }

    @Override
    public long getCompletedTaskCount() {
        if (this.executor instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.executor).getCompletedTaskCount();
        }
        return -1L;
    }
}

