/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterRepConstants;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterWalker;

@DefaultLogger(value="oracle.sql")
@Supports(value={Feature.CHARACTER_PROCESSING})
class CharacterSetUTF
extends CharacterSet
implements CharacterRepConstants {
    private static int[] m_byteLen;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    CharacterSetUTF(int id) {
        super(id);
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$12, null, id);
            }
            this.rep = 2;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isLossyFrom(CharacterSet characterSet) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void from;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$0, this, characterSet);
            }
            boolean bl3 = bl2 = !from.isUnicode();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$0, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$0, this, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isConvertibleFrom(CharacterSet characterSet) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void source;
            boolean ok;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$1, this, characterSet);
            }
            boolean bl2 = ok = source.rep <= 1024;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$1, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$1, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isUnicode() {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$2, this, new Object[0]);
            }
            boolean bl2 = true;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$2, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$2, this, null);
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @DisableTrace
    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        try {
            char[] chars = new char[bytes.length];
            int[] countArr = new int[]{count};
            int chars_len = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, 0, countArr, true);
            return new String(chars, 0, chars_len);
        }
        catch (SQLException e2) {
            return "";
        }
    }

    @Override
    @DisableTrace
    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        try {
            char[] chars = new char[bytes.length];
            int[] countArr = new int[]{count};
            int chars_len = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, 0, countArr, false);
            return new String(chars, 0, chars_len);
        }
        catch (SQLException e2) {
            CharacterSetUTF.failUTFConversion();
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] convertWithReplacement(String string) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$3, this, string);
            }
            byte[] byArray = CharacterSetUTF.stringToUTF((String)str);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$3, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$3, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] convert(String string) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void str;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$4, this, string);
            }
            byte[] byArray = CharacterSetUTF.stringToUTF((String)str);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$4, this, byArray);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$4, this, null);
            }
            return byArray;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] convert(CharacterSet characterSet, byte[] byArray, int n2, int n3) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte[] result;
            void count;
            void offset;
            void source;
            void from;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$5, this, characterSet, byArray, n2, n3);
            }
            if (from.rep == 2) {
                result = CharacterSetUTF.useOrCopy((byte[])source, (int)offset, (int)count);
            } else {
                String s2 = from.toString((byte[])source, (int)offset, (int)count);
                result = CharacterSetUTF.stringToUTF(s2);
            }
            byte[] byArray2 = result;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$5, this, byArray2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$5, this, null);
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n2;
            block13: {
                char[] chars;
                block11: {
                    char c2;
                    block12: {
                        byte c3;
                        int len;
                        void walker;
                        if (bl) {
                            ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$6, this, characterWalker);
                        }
                        byte[] bytes = walker.bytes;
                        int bytes_index = walker.next;
                        int bytes_end = walker.end;
                        if (bytes_index >= bytes_end) {
                            CharacterSetUTF.failUTFConversion();
                        }
                        if ((len = CharacterSetUTF.getUTFByteLength(c3 = bytes[bytes_index])) == 0 || bytes_index + (len - 1) >= bytes_end) {
                            CharacterSetUTF.failUTFConversion();
                        }
                        if (len == 3 && CharacterSetUTF.isHiSurrogate(c3, bytes[bytes_index + 1]) && bytes_index + 5 < bytes_end) {
                            len = 6;
                        }
                        try {
                            chars = new char[2];
                            int[] lenArr = new int[]{len};
                            int chars_len = CharacterSet.convertUTFBytesToJavaChars(bytes, bytes_index, chars, 0, lenArr, false);
                            walker.next += len;
                            if (chars_len != 1) break block11;
                            c2 = chars[0];
                            if (!bl) break block12;
                        }
                        catch (SQLException e2) {
                            CharacterSetUTF.failUTFConversion();
                            int n3 = 0;
                            if (bl) {
                                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$6, this, n3);
                                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$6, this, null);
                            }
                            return 0;
                        }
                        ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$6, this, c2);
                        ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$6, this, null);
                    }
                    return c2;
                }
                n2 = chars[0] << 16 | chars[1];
                if (!bl) break block13;
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$6, this, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$6, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            int n3;
            void buffer;
            void c2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$7, this, characterBuffer, n2);
            }
            if ((c2 & 0xFFFF0000) != 0) {
                CharacterSetUTF.need((CharacterBuffer)buffer, 6);
                char[] chars = new char[]{(char)(c2 >>> 16), (char)c2};
                n3 = CharacterSet.convertJavaCharsToUTFBytes(chars, 0, buffer.bytes, buffer.next, 2);
            } else {
                CharacterSetUTF.need((CharacterBuffer)buffer, 3);
                char[] chars = new char[]{(char)c2};
                n3 = CharacterSet.convertJavaCharsToUTFBytes(chars, 0, buffer.bytes, buffer.next, 1);
            }
            buffer.next += n3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    private static int getUTFByteLength(byte by) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            byte b2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$8, null, by);
            }
            int n2 = m_byteLen[b2 >>> 4 & 0xF];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$8, null, n2);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$8, null, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$8, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isHiSurrogate(byte by, byte by2) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void b2;
            byte b3;
            boolean bl2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$9, null, by, by2);
            }
            boolean bl3 = bl2 = b3 == -19 && b2 >= -96;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$9, null, bl2);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$9, null, null);
            }
            return bl3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$9, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int encodedByteLength(String string) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void s2;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$10, this, string);
            }
            int n2 = CharacterSet.stringUTFLength((String)s2);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$10, this, n2);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$10, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int encodedByteLength(char[] cArray) {
        boolean bl = (0x8000000000L & TraceControllerImpl.feature) != 0L;
        try {
            void carray;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$11, this, new Object[]{cArray});
            }
            int n2 = CharacterSet.charArrayUTF8Length((char[])carray);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$11, this, n2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$11, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, CharacterSetUTF.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = CharacterSetUTF.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$11 = CharacterSetUTF.class.getDeclaredMethod("encodedByteLength", char[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$10 = CharacterSetUTF.class.getDeclaredMethod("encodedByteLength", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$9 = CharacterSetUTF.class.getDeclaredMethod("isHiSurrogate", Byte.TYPE, Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$8 = CharacterSetUTF.class.getDeclaredMethod("getUTFByteLength", Byte.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$7 = CharacterSetUTF.class.getDeclaredMethod("encode", CharacterBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$6 = CharacterSetUTF.class.getDeclaredMethod("decode", CharacterWalker.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$5 = CharacterSetUTF.class.getDeclaredMethod("convert", CharacterSet.class, byte[].class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$4 = CharacterSetUTF.class.getDeclaredMethod("convert", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$3 = CharacterSetUTF.class.getDeclaredMethod("convertWithReplacement", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$2 = CharacterSetUTF.class.getDeclaredMethod("isUnicode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$1 = CharacterSetUTF.class.getDeclaredMethod("isConvertibleFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        try {
            $$$methodRef$$$0 = CharacterSetUTF.class.getDeclaredMethod("isLossyFrom", CharacterSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.sql");
        m_byteLen = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 3, 0};
    }
}

