/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.statement;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;

public enum SqlStatementType {
    QUERY,
    CALL,
    DELETE,
    INSERT,
    UPDATE,
    XQUERY,
    OTHERSQL,
    MERGE,
    CREATE,
    DROP,
    ALTER,
    GRANT,
    REVOKE,
    COMMENT,
    LABEL,
    RENAME,
    DECLAREGLOBALTEMPTABLE,
    SET,
    VALUES,
    COMPOUND,
    SET_METHOD,
    SINGLE_ROW_QUERY;


    public static SqlStatementType getSqlStatementType(String string) {
        for (SqlStatementType sqlStatementType : SqlStatementType.values()) {
            if (!sqlStatementType.name().equals(string)) continue;
            return sqlStatementType;
        }
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INV_SQL_TYPE", string), null, 10324);
    }

    @Deprecated
    public boolean isQuery() {
        return QUERY == this || XQUERY == this;
    }

    public boolean isSqlSetOrSetMethod() {
        return SET == this || SET_METHOD == this;
    }

    public static boolean isDDL(SqlStatementType sqlStatementType) {
        if (null == sqlStatementType) {
            return false;
        }
        switch (sqlStatementType) {
            case CREATE: 
            case DROP: 
            case ALTER: 
            case GRANT: 
            case REVOKE: 
            case COMMENT: 
            case LABEL: 
            case RENAME: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSELECTorXQUERY(SqlStatementType sqlStatementType) {
        if (null == sqlStatementType) {
            return false;
        }
        switch (sqlStatementType) {
            case QUERY: 
            case XQUERY: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSELECTorVALUES(SqlStatementType sqlStatementType) {
        if (null == sqlStatementType) {
            return false;
        }
        switch (sqlStatementType) {
            case QUERY: 
            case VALUES: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSELECTorVALUESorXQUERY(SqlStatementType sqlStatementType) {
        if (null == sqlStatementType) {
            return false;
        }
        switch (sqlStatementType) {
            case QUERY: 
            case XQUERY: 
            case VALUES: {
                return true;
            }
        }
        return false;
    }
}

