/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlConnection;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDatabase;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlDriver;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlOrigin;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlOriginEnvironment;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlSpecialRegValuesSet;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatement;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementSet;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class PDQXml
implements XmlExporter {
    private PDQXmlOrigin origin_;
    private List<PDQXmlStatementSet> statementSets_ = new ArrayList<PDQXmlStatementSet>();
    private String version_ = "4";
    static String currentOriginType__;
    static Connection currentConnection__;
    static int lastCursorIndex__;
    static int lastSqlIndex__;
    static int nonParameterizedSqlCount__;
    static boolean isDB2forZOS__;

    public List<PDQXmlStatementSet> getStatementSets() {
        return this.statementSets_;
    }

    public void setStatementSets(List<PDQXmlStatementSet> list) {
        this.statementSets_ = list;
    }

    public String getVersion() {
        return this.version_;
    }

    public void setVersion(String string) {
        this.version_ = string;
    }

    @Deprecated
    public void initOrigin(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        this.initOrigin(databaseMetaData, string, null, (short)21);
    }

    private void initOrigin(DatabaseMetaData databaseMetaData, String string, PDQXmlSpecialRegValuesSet pDQXmlSpecialRegValuesSet, short s2) throws SQLException {
        Object object;
        Object object2;
        lastCursorIndex__ = 0;
        lastSqlIndex__ = 0;
        nonParameterizedSqlCount__ = 0;
        PDQXmlDriver pDQXmlDriver = new PDQXmlDriver();
        pDQXmlDriver.init(databaseMetaData);
        PDQXmlDatabase pDQXmlDatabase = new PDQXmlDatabase();
        pDQXmlDatabase.init(databaseMetaData);
        PDQXmlConnection pDQXmlConnection = new PDQXmlConnection();
        pDQXmlConnection.init(databaseMetaData, s2);
        if (null != pDQXmlSpecialRegValuesSet && null != (object2 = pDQXmlSpecialRegValuesSet.getSpecialRegValuesSetsMaps())) {
            object = null;
            for (Map.Entry<Integer, Map<String, String>> entry : ((TreeMap)object2).entrySet()) {
                String string2 = entry.getValue().get("SCHEMA");
                if (null == string2) continue;
                if (null == object) {
                    object = string2;
                    continue;
                }
                if (((String)object).equals(string2)) continue;
                object = null;
                break;
            }
            if (null != object) {
                pDQXmlConnection.setConnectionSchema((String)object);
            }
        }
        currentConnection__ = databaseMetaData.getConnection();
        isDB2forZOS__ = this.isDB2forZOS(currentConnection__);
        object2 = new PDQXmlOriginEnvironment();
        ((PDQXmlOriginEnvironment)object2).setPDQXmlConnection(pDQXmlConnection);
        ((PDQXmlOriginEnvironment)object2).setPDQXmlDatabase(pDQXmlDatabase);
        ((PDQXmlOriginEnvironment)object2).setPDQXmlDriver(pDQXmlDriver);
        ((PDQXmlOriginEnvironment)object2).setPDQXmlSpecialRegisterValuesSets(pDQXmlSpecialRegValuesSet);
        object = new PDQXmlOrigin();
        ((PDQXmlOrigin)object).setOriginType(string);
        currentOriginType__ = string;
        ((PDQXmlOrigin)object).setPDQXmlOriginEnvironment((PDQXmlOriginEnvironment)object2);
        this.setOrigin((PDQXmlOrigin)object);
    }

    @Deprecated
    public void initOrigin(Connection connection, String string) throws SQLException {
        this.initOrigin(connection, string, null, (short)21);
    }

    public void initOrigin(Connection connection, String string, PDQXmlSpecialRegValuesSet pDQXmlSpecialRegValuesSet, short s2) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        this.initOrigin(databaseMetaData, string, pDQXmlSpecialRegValuesSet, s2);
    }

    public PDQXmlOrigin getOrigin() {
        return this.origin_;
    }

    public void setOrigin(PDQXmlOrigin pDQXmlOrigin) {
        this.origin_ = pDQXmlOrigin;
    }

    public Integer getDbProductMajorVersion() {
        PDQXmlDatabase pDQXmlDatabase;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlDatabase = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlDatabase()) != null) {
            return pDQXmlDatabase.getDbProductMajorVersion();
        }
        return null;
    }

    public Integer getDbProductMinorVersion() {
        PDQXmlDatabase pDQXmlDatabase;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlDatabase = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlDatabase()) != null) {
            return pDQXmlDatabase.getDbProductMinorVersion();
        }
        return null;
    }

    public String getDbProductName() {
        PDQXmlDatabase pDQXmlDatabase;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlDatabase = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlDatabase()) != null) {
            return pDQXmlDatabase.getDbProductName();
        }
        return null;
    }

    public String getDbProductVersion() {
        PDQXmlDatabase pDQXmlDatabase;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlDatabase = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlDatabase()) != null) {
            return pDQXmlDatabase.getDbProductVersion();
        }
        return null;
    }

    public String getDriverName() {
        PDQXmlDriver pDQXmlDriver;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlDriver = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlDriver()) != null) {
            return pDQXmlDriver.getDriverName();
        }
        return null;
    }

    public String getDriverVersion() {
        PDQXmlDriver pDQXmlDriver;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlDriver = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlDriver()) != null) {
            return pDQXmlDriver.getDriverVersion();
        }
        return null;
    }

    public Integer getDriverMajorVersion() {
        PDQXmlDriver pDQXmlDriver;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlDriver = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlDriver()) != null) {
            return pDQXmlDriver.getDriverMajorVersion();
        }
        return null;
    }

    public Integer getDriverMinorVersion() {
        PDQXmlDriver pDQXmlDriver;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlDriver = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlDriver()) != null) {
            return pDQXmlDriver.getDriverMinorVersion();
        }
        return null;
    }

    public String getConnectionURL() {
        PDQXmlConnection pDQXmlConnection;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlConnection = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlConnection()) != null) {
            return pDQXmlConnection.getConnectionURL();
        }
        return null;
    }

    public String getConnectionUserName() {
        PDQXmlConnection pDQXmlConnection;
        if (this.origin_ != null && this.origin_.getPDQXmlOriginEnvironment() != null && (pDQXmlConnection = this.origin_.getPDQXmlOriginEnvironment().getPDQXmlConnection()) != null) {
            return pDQXmlConnection.getConnectionUserName();
        }
        return null;
    }

    public String getXmlStart(int n2) {
        String string = XmlTags.space(n2);
        return string + "<" + "programSet" + " xmlns=\"http://www.ibm.com/xmlns/prod/optim/pureQuery/programSetV4\"" + (this.version_ != null ? " version=\"" + this.version_ + "\"" : "") + ">" + (this.origin_ != null ? this.origin_.getXml(n2 + 2) : "");
    }

    public String getXmlEnd(int n2) {
        lastCursorIndex__ = 0;
        lastSqlIndex__ = 0;
        nonParameterizedSqlCount__ = 0;
        currentConnection__ = null;
        String string = XmlTags.space(n2);
        return string + "</" + "programSet" + ">";
    }

    @Override
    public String getXml(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getXmlStart(0));
        for (PDQXmlStatementSet pDQXmlStatementSet : this.statementSets_) {
            stringBuilder.append(XmlTags.CRLF);
            stringBuilder.append(pDQXmlStatementSet.getXmlStart(2));
            for (PDQXmlStatement pDQXmlStatement : pDQXmlStatementSet.getStatements()) {
                stringBuilder.append(pDQXmlStatement.getXml(6));
            }
            stringBuilder.append(XmlTags.CRLF);
            stringBuilder.append(pDQXmlStatementSet.getXmlEnd(2));
        }
        stringBuilder.append(XmlTags.CRLF);
        stringBuilder.append(this.getXmlEnd(0));
        return stringBuilder.toString();
    }

    private boolean isDB2forZOS(Connection connection) {
        if (connection == null) {
            ToolsLogger.getLogger().log(Level.WARNING, "pureQuery could not detect database type because connection is null.");
            return false;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getDatabaseProductVersion();
            if (string != null && string.startsWith("DSN")) {
                return true;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return false;
    }
}

