/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.interop;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.runtime.interop.InteropMap;
import com.oracle.graal.python.runtime.interop.MergedPropertyNames;
import com.oracle.graal.python.runtime.interop.PythonLocalScope;
import com.oracle.graal.python.runtime.interop.PythonMapScope;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.source.SourceSection;

@ExportLibrary(value=InteropLibrary.class)
public final class PythonScopes
implements TruffleObject {
    static final int LIMIT = 2;
    public final Object[] scopes;
    private final int scopeIndex;

    public PythonScopes(Object[] scopes, int scopeIndex) {
        this.scopes = scopes;
        this.scopeIndex = scopeIndex;
    }

    private static InteropMap scopeFromObject(PythonObject globals) {
        if (globals instanceof PDict) {
            return InteropMap.fromPDict((PDict)globals);
        }
        return InteropMap.fromPythonObject(globals);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object create(Node node, Frame frame) {
        Object[] scopes;
        RootNode root = node.getRootNode();
        PythonLocalScope localScope = PythonLocalScope.createLocalScope(root, frame != null ? frame.materialize() : null);
        if (frame == null) return localScope;
        PythonObject globals = PArguments.getGlobalsSafe(frame);
        MaterializedFrame generatorFrame = PArguments.getGeneratorFrameSafe(frame);
        PythonMapScope globalsScope = null;
        if (globals != null) {
            globalsScope = new PythonMapScope(new Object[]{PythonScopes.scopeFromObject(globals)}, new String[]{"globals()"});
        }
        if (globals != null && generatorFrame != null) {
            scopes = new Object[]{localScope, globalsScope, PythonLocalScope.createLocalScope(root, generatorFrame)};
            return new PythonScopes(scopes, 0);
        } else if (globals != null) {
            scopes = new Object[]{localScope, globalsScope};
            return new PythonScopes(scopes, 0);
        } else {
            if (generatorFrame == null) return localScope;
            scopes = new Object[]{localScope, PythonLocalScope.createLocalScope(root, generatorFrame)};
        }
        return new PythonScopes(scopes, 0);
    }

    @ExportMessage
    boolean isScope() {
        return true;
    }

    @ExportMessage
    boolean hasScopeParent() {
        return this.scopeIndex < this.scopes.length - 1;
    }

    @ExportMessage
    Object getScopeParent() throws UnsupportedMessageException {
        if (this.scopeIndex < this.scopes.length - 1) {
            return new PythonScopes(this.scopes, this.scopeIndex + 1);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean hasSourceLocation(@Cached.Shared(value="sourceInterop") @CachedLibrary(limit="1") InteropLibrary lib) {
        return lib.hasSourceLocation(this.scopes[this.scopeIndex]);
    }

    @ExportMessage
    public SourceSection getSourceLocation(@Cached.Shared(value="sourceInterop") @CachedLibrary(limit="1") InteropLibrary lib) throws UnsupportedMessageException {
        return lib.getSourceLocation(this.scopes[this.scopeIndex]);
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return PythonLanguage.class;
    }

    @ExportMessage
    boolean hasMembers(@Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.scopes.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object vars = this.scopes[i];
            if (!interop.hasMembers(vars)) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) throws UnsupportedMessageException {
        int length = lengthProfile.profile(inliningTarget, this.scopes.length);
        Object[] keys = new Object[length - this.scopeIndex];
        for (int i = this.scopeIndex; i < length; ++i) {
            keys[i - this.scopeIndex] = interop.getMembers(this.scopes[i]);
        }
        return new MergedPropertyNames(keys);
    }

    @ExportMessage
    boolean isMemberReadable(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.scopes.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.scopes[i];
            if (interop.isMemberReadable(scope, member)) {
                return true;
            }
            if (interop.isMemberExisting(scope, member)) break;
        }
        return false;
    }

    @ExportMessage
    Object readMember(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) throws UnknownIdentifierException, UnsupportedMessageException {
        int length = lengthProfile.profile(inliningTarget, this.scopes.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.scopes[i];
            if (!interop.isMemberExisting(scope, member)) continue;
            return interop.readMember(scope, member);
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    void writeMember(String member, Object value, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) throws UnknownIdentifierException, UnsupportedMessageException, UnsupportedTypeException {
        int length = lengthProfile.profile(inliningTarget, this.scopes.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.scopes[i];
            if (!interop.isMemberExisting(scope, member)) continue;
            interop.writeMember(scope, member, value);
            return;
        }
        throw UnknownIdentifierException.create((String)member);
    }

    @ExportMessage
    boolean isMemberModifiable(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.scopes.length);
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.scopes[i];
            if (interop.isMemberModifiable(scope, member)) {
                return true;
            }
            if (interop.isMemberExisting(scope, member)) break;
        }
        return false;
    }

    @ExportMessage
    boolean isMemberInsertable(String member, @Bind Node inliningTarget, @Cached.Shared(value="interop") @CachedLibrary(limit="LIMIT") InteropLibrary interop, @Cached.Shared(value="lenghtProfile") @Cached InlinedIntValueProfile lengthProfile) {
        int length = lengthProfile.profile(inliningTarget, this.scopes.length);
        boolean wasInsertable = false;
        for (int i = this.scopeIndex; i < length; ++i) {
            Object scope = this.scopes[i];
            if (interop.isMemberExisting(scope, member)) {
                return false;
            }
            if (!interop.isMemberInsertable(scope, member)) continue;
            wasInsertable = true;
        }
        return wasInsertable;
    }

    @ExportMessage
    Object toDisplayString(boolean allowSideEffects, @Cached.Exclusive @CachedLibrary(limit="1") InteropLibrary lib) {
        return lib.toDisplayString(this.scopes[this.scopeIndex]);
    }
}

