/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.ImmutableColumnReference;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableWeakAssociation;
import schemacrawler.crawl.RetrieverUtility;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.ColumnReference;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Schema;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableReference;
import schemacrawler.schema.WeakAssociation;
import us.fatehi.utility.Builder;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class WeakAssociationBuilder
implements Builder<TableReference> {
    private static final Logger LOGGER = Logger.getLogger(WeakAssociationBuilder.class.getName());
    private final Catalog catalog;
    private final Collection<ColumnReference> columnReferences;

    public static WeakAssociationBuilder builder(Catalog catalog) {
        return new WeakAssociationBuilder(catalog);
    }

    private WeakAssociationBuilder(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.columnReferences = new HashSet<ColumnReference>();
    }

    public WeakAssociationBuilder addColumnReference(WeakAssociationColumn referencingColumn, WeakAssociationColumn referencedColumn) {
        Objects.requireNonNull(referencingColumn, "No referencing column provided");
        Objects.requireNonNull(referencedColumn, "No referenced column provided");
        Column fkColumn = RetrieverUtility.lookupOrCreateColumn(this.catalog, referencingColumn.getSchema(), referencingColumn.getTableName(), referencingColumn.getColumnName());
        Column pkColumn = RetrieverUtility.lookupOrCreateColumn(this.catalog, referencedColumn.getSchema(), referencedColumn.getTableName(), referencedColumn.getColumnName());
        Objects.requireNonNull(fkColumn, "No referencing column provided");
        Objects.requireNonNull(pkColumn, "No referenced column provided");
        if (fkColumn.equals(pkColumn)) {
            return this;
        }
        boolean isFkColumnPartial = fkColumn instanceof PartialDatabaseObject;
        boolean isPkColumnPartial = pkColumn instanceof PartialDatabaseObject;
        if (isFkColumnPartial && isPkColumnPartial) {
            return this;
        }
        int keySequence = this.columnReferences.size() + 1;
        ImmutableColumnReference columnReference = new ImmutableColumnReference(keySequence, fkColumn, pkColumn);
        this.columnReferences.add(columnReference);
        return this;
    }

    public TableReference build() {
        Optional<TableReference> optionalTableReference = this.findOrCreate(null);
        if (optionalTableReference.isPresent()) {
            return optionalTableReference.get();
        }
        return null;
    }

    public WeakAssociationBuilder clear() {
        this.columnReferences.clear();
        LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Builder <%s> cleared", new Object[]{this.hashCode()}));
        return this;
    }

    public Optional<TableReference> findOrCreate(String name) {
        MutableTable table;
        if (this.columnReferences.isEmpty()) {
            LOGGER.log(Level.CONFIG, "Weak association not built, since there are no column references");
            return Optional.empty();
        }
        Iterator<ColumnReference> iterator = this.columnReferences.iterator();
        ColumnReference someColumnReference = iterator.next();
        Table referencedTable = (Table)someColumnReference.getPrimaryKeyColumn().getParent();
        Table dependentTable = (Table)someColumnReference.getForeignKeyColumn().getParent();
        String weakAssociationName = Utility.isBlank((String)name) ? RetrieverUtility.constructForeignKeyName(referencedTable, dependentTable) : name;
        MutableWeakAssociation weakAssociation = new MutableWeakAssociation(weakAssociationName, someColumnReference);
        while (iterator.hasNext()) {
            ColumnReference columnReference = iterator.next();
            boolean addedColumnReference = weakAssociation.addColumnReference(columnReference);
            if (addedColumnReference) continue;
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Weak association not built, since column references are not consistent, %s", new Object[]{this.columnReferences}));
            return Optional.empty();
        }
        Optional<ForeignKey> optionalMatchingForeignKey = this.lookupMatchingForeignKey(weakAssociation);
        if (optionalMatchingForeignKey.isPresent()) {
            return Optional.of((TableReference)optionalMatchingForeignKey.get());
        }
        Optional<WeakAssociation> optionalMatchingWeakAssociation = this.lookupMatchingWeakAssociation(weakAssociation);
        if (optionalMatchingWeakAssociation.isPresent()) {
            return Optional.of((TableReference)optionalMatchingWeakAssociation.get());
        }
        if (referencedTable instanceof MutableTable) {
            table = (MutableTable)referencedTable;
            table.addWeakAssociation(weakAssociation);
        }
        if (dependentTable instanceof MutableTable) {
            table = (MutableTable)dependentTable;
            table.addWeakAssociation(weakAssociation);
        }
        return Optional.of(weakAssociation);
    }

    private Optional<ForeignKey> lookupMatchingForeignKey(WeakAssociation weakAssociation) {
        Objects.requireNonNull(weakAssociation, "No weak association provided");
        Table referencedTable = weakAssociation.getReferencedTable();
        if (!(referencedTable instanceof MutableTable)) {
            return Optional.empty();
        }
        Collection<ForeignKey> exportedForeignKeys = referencedTable.getExportedForeignKeys();
        for (ForeignKey foreignKey : exportedForeignKeys) {
            if (weakAssociation.compareTo(foreignKey) != 0) continue;
            return Optional.of(foreignKey);
        }
        return Optional.empty();
    }

    private Optional<WeakAssociation> lookupMatchingWeakAssociation(WeakAssociation weakAssociation) {
        Objects.requireNonNull(weakAssociation, "No weak association provided");
        Table referencedTable = weakAssociation.getReferencedTable();
        if (!(referencedTable instanceof MutableTable)) {
            return Optional.empty();
        }
        Collection<WeakAssociation> weakAssociations = referencedTable.getWeakAssociations();
        for (WeakAssociation weakAssociationInTable : weakAssociations) {
            if (weakAssociation.compareTo(weakAssociationInTable) != 0) continue;
            return Optional.of(weakAssociationInTable);
        }
        return Optional.empty();
    }

    public static final class WeakAssociationColumn {
        private final Schema schema;
        private final String tableName;
        private final String columnName;

        public WeakAssociationColumn(Column column) {
            this(Objects.requireNonNull(column, "No column provided").getSchema(), ((Table)column.getParent()).getName(), column.getName());
        }

        public WeakAssociationColumn(Schema schema, String table, String column) {
            this.schema = Objects.requireNonNull(schema, "No schema provided");
            this.tableName = Utility.requireNotBlank((String)table, (String)"No table name provided");
            this.columnName = Utility.requireNotBlank((String)column, (String)"No column name provided");
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return "weak-association <%s.%s.%s>".formatted(this.schema, this.tableName, this.columnName);
        }
    }
}

