/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.binary.OsonAbstractArray;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonBuffer;
import oracle.jdbc.driver.json.binary.OsonConstants;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.jdbc.driver.json.binary.OsonHeader;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;
import oracle.jdbc.driver.json.binary.OsonValueFactory;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonValue;

public abstract class OsonStructureImpl {
    OsonContext ctx;
    int pos;
    public int size;
    byte childOffsetUb;
    int childArrayOffset;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;

    public OsonStructureImpl(OsonContext ctx) {
        this.ctx = ctx;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    void init(int pos) {
        this.pos = pos;
    }

    void initChildOffseUb(int op) {
        this.childOffsetUb = (op & 0x20) != 0 ? (byte)4 : (byte)2;
    }

    Boolean getBooleanInternal(int offset) {
        int op = this.ctx.b.getUB1(offset);
        if (op < 0) {
            return null;
        }
        if (op == 49) {
            return true;
        }
        if (op == 50) {
            return false;
        }
        return null;
    }

    String getStringInternal(int offset) {
        int op = this.ctx.b.getUB1(offset);
        if (op < 0) {
            return null;
        }
        if (op <= 31) {
            this.ctx.b.position(offset + 1);
            return this.ctx.b.readString(op);
        }
        if (op == 51) {
            int len = this.ctx.b.getUB1(offset + 1);
            this.ctx.b.position(offset + 2);
            return this.ctx.b.readString(len);
        }
        if (op == 55) {
            int len = this.ctx.b.getUB2(offset + 1);
            this.ctx.b.position(offset + 3);
            return this.ctx.b.readString(len);
        }
        if (op == 56) {
            int len = this.ctx.b.getUB4int(offset + 1);
            this.ctx.b.position(offset + 5);
            return this.ctx.b.readString(len);
        }
        return null;
    }

    boolean isNullInternal(int childOffset) {
        int op = this.ctx.b.getUB1(childOffset);
        if (op < 0) {
            return false;
        }
        return op == 48;
    }

    public Object getValueInternal(int offset) {
        return OsonStructureImpl.getValueInternal(offset, this.ctx.getFactory(), this.ctx);
    }

    public static Object getValueInternal(int offset, OsonValueFactory factory, OsonContext ctx) {
        int op = ctx.b.getUB1(offset);
        if ((op & 0xC0) == 192) {
            return factory.createArray(ctx, offset);
        }
        if ((op & 0xC0) == 128) {
            if ((op & 0x83) == 131) {
                return OsonStructureImpl.getOverflowValue(offset, factory, ctx);
            }
            return factory.createObject(ctx, offset);
        }
        if (op <= 31) {
            return factory.createString(ctx, offset + 1, op);
        }
        if (OsonConstants.isSB4(op)) {
            return factory.createNumber(OsonStructureImpl.readRaw(offset + 1, op & 7, ctx), OracleJsonDecimal.TargetType.INT);
        }
        if (OsonConstants.isSB8(op)) {
            return factory.createNumber(OsonStructureImpl.readRaw(offset + 1, op & 0xF, ctx), OracleJsonDecimal.TargetType.LONG);
        }
        if (OsonConstants.isOraNum16(op)) {
            return factory.createNumber(OsonStructureImpl.readRaw(offset + 1, (op & 0xF) + 1, ctx), null);
        }
        if (OsonConstants.isDec_16(op)) {
            return factory.createNumber(OsonStructureImpl.readRaw(offset + 1, (op & 0xF) + 1, ctx), OracleJsonDecimal.TargetType.DECIMAL);
        }
        switch (op) {
            case 49: {
                return factory.createTrue();
            }
            case 50: {
                return factory.createFalse();
            }
            case 48: {
                return factory.createNull();
            }
            case 51: {
                int len = ctx.b.getUB1(offset + 1);
                return factory.createString(ctx, offset + 2, len);
            }
            case 55: {
                int len = ctx.b.getUB2(offset + 1);
                return factory.createString(ctx, offset + 3, len);
            }
            case 56: {
                int len = ctx.b.getUB4int(offset + 1);
                ctx.b.position(offset + 5);
                return factory.createString(ctx, offset + 5, len);
            }
            case 54: {
                ctx.b.position(offset + 1);
                return factory.createDouble(ctx.b.readDtyDouble());
            }
            case 127: {
                ctx.b.position(offset + 1);
                return factory.createFloat(ctx.b.readDtyFloat());
            }
            case 53: {
                int len = ctx.b.getUB1(offset + 1);
                ctx.b.position(offset + 2);
                String num = ctx.b.readString(len);
                return factory.createStringNumber(num);
            }
            case 52: {
                byte[] raw = OsonStructureImpl.readRaw(offset + 2, ctx.b.getUB1(offset + 1), ctx);
                return factory.createNumber(raw, null);
            }
            case 116: {
                byte[] raw = OsonStructureImpl.readRaw(offset + 2, ctx.b.getUB1(offset + 1), ctx);
                return factory.createNumber(raw, OracleJsonDecimal.TargetType.DECIMAL);
            }
            case 126: {
                int len = ctx.b.getUB1(offset + 1);
                if (len > 127 || len < 0) {
                    throw new UnsupportedOperationException(String.valueOf(op));
                }
                return factory.createBinary(ctx, offset + 2, len, true);
            }
            case 58: {
                int len = ctx.b.getUB2(offset + 1);
                return factory.createBinary(ctx, offset + 3, len, false);
            }
            case 59: {
                int len = ctx.b.getUB4int(offset + 1);
                return factory.createBinary(ctx, offset + 5, len, false);
            }
            case 57: 
            case 125: {
                return factory.createTimestamp(OsonStructureImpl.readTimestamp(ctx.b, offset));
            }
            case 124: {
                return factory.createTimestampTZ(OsonStructureImpl.readTimestampTZ(ctx.b, offset));
            }
            case 60: {
                return factory.createDate(OsonStructureImpl.readRaw(offset + 1, 7, ctx));
            }
            case 61: {
                return factory.createIntervalYM(OsonStructureImpl.readRaw(offset + 1, 5, ctx));
            }
            case 62: {
                return factory.createIntervalDS(OsonStructureImpl.readRaw(offset + 1, 11, ctx));
            }
            case 117: {
                return OsonStructureImpl.getOverflowValue(offset, factory, ctx);
            }
            case 118: {
                return OsonStructureImpl.getForwardedValue(ctx.b.getUB2(offset + 1), factory, ctx);
            }
            case 119: {
                return OsonStructureImpl.getForwardedValue(ctx.b.getUB4int(offset + 1), factory, ctx);
            }
        }
        throw new UnsupportedOperationException(String.valueOf(op));
    }

    private static Object getForwardedValue(int relativeOffset, OsonValueFactory factory, OsonContext ctx) {
        int fwd = relativeOffset + ctx.header.extendedTreeSegmentOffset;
        return OsonStructureImpl.getValueInternal(fwd, factory, ctx);
    }

    private static Object getOverflowValue(int absoluteOffset, OsonValueFactory factory, OsonContext ctx) {
        int relativeOffset = absoluteOffset - ctx.header.treeSegmentOffset;
        OsonHeader header = ctx.header;
        int fwd = header.forwardingAddress.get(relativeOffset) + header.extendedTreeSegmentOffset;
        return OsonStructureImpl.getValueInternal(fwd, factory, ctx);
    }

    private static byte[] readRaw(int offset, int len, OsonContext ctx) {
        ctx.b.position(offset);
        byte[] res = new byte[len];
        ctx.b.get(res);
        return res;
    }

    protected static byte[] readTimestamp(OsonBuffer b2, int offset) {
        int len;
        int op = b2.getUB1(offset);
        if (op == 125) {
            len = OsonPrimitiveConversions.SIZE_TIMESTAMP_NOFRAC;
        } else if (op == 57) {
            len = OsonPrimitiveConversions.SIZE_TIMESTAMP;
        } else {
            throw new ClassCastException();
        }
        byte[] raw = new byte[len];
        b2.position(offset + 1);
        b2.get(raw);
        return raw;
    }

    protected static byte[] readTimestampTZ(OsonBuffer b2, int offset) {
        byte[] raw = new byte[OsonPrimitiveConversions.SIZE_TIMESTAMPTZ];
        b2.position(offset + 1);
        b2.get(raw);
        return raw;
    }

    protected OsonAbstractArray getArrayInternal(int childOffset) {
        int op = this.ctx.b.getUB1(childOffset);
        if ((op & 0xC0) == 192) {
            return this.ctx.getFactory().createArray(this.ctx, childOffset);
        }
        throw new ClassCastException();
    }

    protected OsonAbstractObject getJsonObjectInternal(int childOffset) {
        int op = this.ctx.b.getUB1(childOffset);
        if ((op & 0xC0) == 128) {
            return this.ctx.getFactory().createObject(this.ctx, childOffset);
        }
        throw new ClassCastException();
    }

    protected abstract int getChildOffset(int var1);

    public abstract OracleJsonValue.OracleJsonType getOracleJsonType();

    public ByteBuffer getBuffer() {
        ByteBuffer b2 = this.ctx.b.buffer;
        b2.position(0);
        return b2;
    }

    public boolean isRoot() {
        return this.pos == this.ctx.header.getTreeSegmentOffset();
    }

    static {
        try {
            $$$methodRef$$$18 = OsonStructureImpl.class.getDeclaredConstructor(OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonStructureImpl.class.getDeclaredMethod("isRoot", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonStructureImpl.class.getDeclaredMethod("getBuffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonStructureImpl.class.getDeclaredMethod("getJsonObjectInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonStructureImpl.class.getDeclaredMethod("getArrayInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonStructureImpl.class.getDeclaredMethod("readTimestampTZ", OsonBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonStructureImpl.class.getDeclaredMethod("readTimestamp", OsonBuffer.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonStructureImpl.class.getDeclaredMethod("readRaw", Integer.TYPE, Integer.TYPE, OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonStructureImpl.class.getDeclaredMethod("getOverflowValue", Integer.TYPE, OsonValueFactory.class, OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonStructureImpl.class.getDeclaredMethod("getForwardedValue", Integer.TYPE, OsonValueFactory.class, OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonStructureImpl.class.getDeclaredMethod("getValueInternal", Integer.TYPE, OsonValueFactory.class, OsonContext.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonStructureImpl.class.getDeclaredMethod("getValueInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonStructureImpl.class.getDeclaredMethod("isNullInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonStructureImpl.class.getDeclaredMethod("getStringInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonStructureImpl.class.getDeclaredMethod("getBooleanInternal", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonStructureImpl.class.getDeclaredMethod("initChildOffseUb", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonStructureImpl.class.getDeclaredMethod("init", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonStructureImpl.class.getDeclaredMethod("isEmpty", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonStructureImpl.class.getDeclaredMethod("size", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }

    public abstract class PositionIter<T>
    implements Iterator<T> {
        protected int ipos = 0;
        private static Executable $$$methodRef$$$0;
        private static Logger $$$loggerRef$$$0;
        private static Executable $$$methodRef$$$1;
        private static Logger $$$loggerRef$$$1;
        private static Executable $$$methodRef$$$2;
        private static Logger $$$loggerRef$$$2;

        @Override
        public boolean hasNext() {
            return this.ipos < OsonStructureImpl.this.size;
        }

        @Override
        public T next() {
            if (this.ipos >= OsonStructureImpl.this.size) {
                throw new NoSuchElementException();
            }
            return this.getValue(this.ipos++);
        }

        public abstract T getValue(int var1);

        static {
            try {
                $$$methodRef$$$2 = PositionIter.class.getDeclaredConstructor(OsonStructureImpl.class);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$1 = PositionIter.class.getDeclaredMethod("next", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            try {
                $$$methodRef$$$0 = PositionIter.class.getDeclaredMethod("hasNext", new Class[0]);
            }
            catch (Throwable throwable) {}
            $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        }
    }
}

