/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.profiler.impl;

import com.oracle.truffle.api.Option;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.tools.profiler.HeapMonitor;
import com.oracle.truffle.tools.profiler.impl.HeapMonitorInstrumentOptionDescriptors;
import com.oracle.truffle.tools.profiler.impl.ProfilerToolFactory;
import java.lang.reflect.Method;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.Instrument;

@TruffleInstrument.Registration(id="heapmonitor", name="Heap Allocation Monitor", version="0.1.0", services={HeapMonitor.class})
public class HeapMonitorInstrument
extends TruffleInstrument {
    public static final String ID = "heapmonitor";
    static final String VERSION = "0.1.0";
    private HeapMonitor monitor;
    private static final ProfilerToolFactory<HeapMonitor> factory = HeapMonitorInstrument.getDefaultFactory();
    @Option(name="", help="Start the heap allocation monitor with the application. This produces no output but improves the precision of the data provided to third party tools.", category=OptionCategory.USER)
    static final OptionKey<Boolean> ENABLED = new OptionKey((Object)false);

    private static ProfilerToolFactory<HeapMonitor> getDefaultFactory() {
        try {
            Method createFactory = HeapMonitor.class.getDeclaredMethod("createFactory", new Class[0]);
            createFactory.setAccessible(true);
            return (ProfilerToolFactory)createFactory.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static HeapMonitor getMonitor(Engine engine) {
        Instrument instrument = (Instrument)engine.getInstruments().get(ID);
        if (instrument == null) {
            throw new IllegalStateException("Heap Monitor is not installed.");
        }
        return (HeapMonitor)instrument.lookup(HeapMonitor.class);
    }

    protected void onCreate(TruffleInstrument.Env env) {
        this.monitor = factory.create(env);
        if (((Boolean)env.getOptions().get(ENABLED)).booleanValue()) {
            this.monitor.setCollecting(true);
        }
        env.registerService((Object)this.monitor);
    }

    protected OptionDescriptors getOptionDescriptors() {
        return new HeapMonitorInstrumentOptionDescriptors();
    }

    protected void onDispose(TruffleInstrument.Env env) {
        this.monitor.close();
    }
}

