/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import schemacrawler.schemacrawler.exceptions.IORuntimeException;
import schemacrawler.tools.command.script.ScriptExecutor;
import schemacrawler.tools.command.script.options.ScriptLanguageType;

public final class GraalScriptExecutor
implements ScriptExecutor {
    private static final Logger LOGGER = Logger.getLogger(GraalScriptExecutor.class.getName());
    private final ScriptLanguageType scriptingLanguage;
    private Reader reader;
    private Writer writer;
    private Map<String, Object> context;

    public GraalScriptExecutor(ScriptLanguageType scriptingLanguage) {
        this.scriptingLanguage = Objects.requireNonNull(scriptingLanguage, "No scripting language provided");
        if (scriptingLanguage == ScriptLanguageType.unknown) {
            throw new IllegalArgumentException("Unknown scripting language");
        }
    }

    @Override
    public boolean canGenerate() {
        boolean bl;
        block8: {
            String language = this.scriptingLanguage.name();
            Context graalPolyglotContext = Context.newBuilder((String[])new String[]{language}).allowAllAccess(true).build();
            try {
                graalPolyglotContext.eval(language, (CharSequence)"1");
                bl = true;
                if (graalPolyglotContext == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (graalPolyglotContext != null) {
                        try {
                            graalPolyglotContext.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            graalPolyglotContext.close();
        }
        return bl;
    }

    @Override
    public void initialize(Map<String, Object> context, Reader reader, Writer writer) {
        this.reader = Objects.requireNonNull(reader, "No script input resource provided");
        this.writer = Objects.requireNonNull(writer, "No output writer provided");
        this.context = context == null ? Collections.emptyMap() : new HashMap<String, Object>(context);
    }

    @Override
    public void run() {
        String language = this.scriptingLanguage.name();
        LOGGER.log(Level.INFO, "Executing %s script".formatted(language));
        try (Context graalPolyglotContext = Context.newBuilder((String[])new String[]{language}).allowAllAccess(true).out((OutputStream)new WriterOutputStream(this.writer)).build();){
            Source sourceCode = Source.newBuilder((String)language, (Reader)this.reader, (String)"schemacrawler_script_execution").build();
            Value bindings = graalPolyglotContext.getBindings(language);
            for (Map.Entry<String, Object> entry : this.context.entrySet()) {
                bindings.putMember(entry.getKey(), entry.getValue());
            }
            graalPolyglotContext.eval(sourceCode);
        }
        catch (IOException e) {
            throw new IORuntimeException(e.getMessage(), e);
        }
    }

    private static class WriterOutputStream
    extends OutputStream {
        private final Writer writer;

        public WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String str = new String(b, off, len, StandardCharsets.UTF_8);
            this.writer.write(str);
        }

        @Override
        public void write(int b) throws IOException {
            this.writer.write(b);
        }
    }
}

