/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.encodings;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.firebirdsql.encodings.Encoding;

final class EncodingGeneric
implements Encoding {
    private final Charset charset;

    EncodingGeneric(Charset charset) {
        this.charset = charset;
    }

    @Override
    public byte[] encodeToCharset(String in) {
        return in.getBytes(this.charset);
    }

    @Override
    public String decodeFromCharset(byte[] in) {
        return new String(in, this.charset);
    }

    @Override
    public String decodeFromCharset(byte[] in, int offset, int length) {
        return new String(in, offset, length, this.charset);
    }

    @Override
    public String getCharsetName() {
        return this.charset.name();
    }

    @Override
    public Reader createReader(InputStream inputStream) {
        return new InputStreamReader(inputStream, this.charset);
    }

    @Override
    public Writer createWriter(OutputStream outputStream) {
        return new OutputStreamWriter(outputStream, this.charset);
    }
}

