\name{GrayscaleErodeImageFilter}
\alias{GrayscaleErodeImageFilter}
\title{GrayscaleErodeImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Grayscale erosion of an image.
GrayscaleErodeImageFilter}
\details{
Erode an image using grayscale morphology. Erosion takes the maximum
of all the pixels identified by the structuring element.
The structuring element is assumed to be composed of binary values
(zero or one). Only elements of the structuring element having values
> 0 are candidates for affecting the center pixel.
See:
MorphologyImageFilter , GrayscaleFunctionErodeImageFilter , BinaryErodeImageFilter
GrayscaleErode for the procedural interface
itk::GrayscaleErodeImageFilter for the Doxygen on the original ITK class.
GrayscaleErodeImageFilter}
%C++ includes: sitkGrayscaleErodeImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::vector< unsigned int > GetKernelRadius() const:}{
Get the radius of the kernel structuring element.
}
\item{KernelEnum GetKernelType() const:}{
Get the kernel or structuring element used for the morphology.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{ GrayscaleErodeImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetKernelRadius(std::vector< unsigned int > KernelRadius):}{
Set the radius of the kernel structuring element.
}
\item{Self SetKernelRadius(unsigned int value):}{
Set the values of the KernelRadius vector all to value
}
\item{Self SetKernelType(KernelEnum KernelType):}{
Set the kernel or structuring element used for the morphology.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~GrayscaleErodeImageFilter():}{
Destructor
}
}
}
