/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.criteria.role.impl;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.criteria.role.EvaluableRoleDescriptorCriterion;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;

public class EvaluableEntityRoleDescriptorCriterion
implements EvaluableRoleDescriptorCriterion {
    @Nonnull
    @NotEmpty
    private QName role;

    public EvaluableEntityRoleDescriptorCriterion(@Nonnull EntityRoleCriterion criterion) {
        Constraint.isNotNull(criterion, "EntityRoleCriterion was null");
        this.role = Constraint.isNotNull(criterion.getRole(), "Criterion entity role was null");
    }

    public EvaluableEntityRoleDescriptorCriterion(@Nonnull QName entityRole) {
        this.role = Constraint.isNotNull(entityRole, "Entity role QName was null");
    }

    @Override
    public boolean test(@Nullable RoleDescriptor input) {
        if (input == null) {
            return false;
        }
        QName schemaType = input.getSchemaType();
        if (schemaType != null && Objects.equals(this.role, schemaType)) {
            return true;
        }
        return Objects.equals(this.role, input.getElementQName());
    }

    public int hashCode() {
        return this.role.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EvaluableEntityRoleDescriptorCriterion) {
            EvaluableEntityRoleDescriptorCriterion other = (EvaluableEntityRoleDescriptorCriterion)obj;
            return Objects.equals(this.role, other.role);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("role", (Object)this.role).toString();
    }
}

