/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries.internal.circuitbreaker;

import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.retries.internal.circuitbreaker.TokenBucket;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.cache.lru.LruCache;

@SdkInternalApi
public final class TokenBucketStore {
    private static final int DEFAULT_MAX_TOKENS = 500;
    private static final int MAX_ENTRIES = 128;
    private final int tokenBucketMaxCapacity;
    private final LruCache<String, TokenBucket> scopeToTokenBucket;

    private TokenBucketStore(Builder builder) {
        this.tokenBucketMaxCapacity = builder.tokenBucketMaxCapacity;
        this.scopeToTokenBucket = LruCache.builder(x -> new TokenBucket(this.tokenBucketMaxCapacity)).maxSize(Integer.valueOf(128)).build();
    }

    public TokenBucket tokenBucketForScope(String scope) {
        Validate.paramNotNull((Object)scope, (String)"scope");
        return (TokenBucket)this.scopeToTokenBucket.get((Object)scope);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int tokenBucketMaxCapacity = 500;

        Builder() {
        }

        public Builder tokenBucketMaxCapacity(int tokenBucketMaxCapacity) {
            this.tokenBucketMaxCapacity = tokenBucketMaxCapacity;
            return this;
        }

        public TokenBucketStore build() {
            return new TokenBucketStore(this);
        }
    }

    static final class LruMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 885024284016559479L;

        LruMap() {
            super(128, 1.0f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 128;
        }
    }
}

