/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.index;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.lucene.search.join.ScoreMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.MatchQueryBuilder;
import org.opensearch.index.query.NestedQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.QueryStringQueryBuilder;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.index.query.TermQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010 \u001a\u00020\u00052\b\u0010!\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/opensearch/notifications/index/EventQueryHelper;", "", "()V", "ALL_FIELDS", "", "", "EVENT_FIELDS", "FILTER_PARAMS", "getFILTER_PARAMS", "()Ljava/util/Set;", "KEYWORD_FIELDS", "KEYWORD_SUFFIX", "KEY_PREFIX", "METADATA_FIELDS", "METADATA_RANGE_FIELDS", "NESTED_FIELDS", "NESTED_KEYWORD_FIELDS", "NESTED_PATH", "NESTED_TEXT_FIELDS", "TEXT_FIELDS", "addQueryFilters", "", "query", "Lorg/opensearch/index/query/BoolQueryBuilder;", "filterParams", "", "getMatchQueryBuilder", "Lorg/opensearch/index/query/QueryBuilder;", "queryKey", "queryValue", "getQueryAllBuilder", "getRangeQueryBuilder", "getSortField", "sortField", "getTermsQueryBuilder", "getTextQueryAllBuilder", "opensearch-notifications"})
@SourceDebugExtension(value={"SMAP\nEventQueryHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventQueryHelper.kt\norg/opensearch/notifications/index/EventQueryHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,175:1\n215#2,2:176\n1855#3,2:178\n1855#3,2:180\n1855#3,2:182\n1855#3,2:184\n*S KotlinDebug\n*F\n+ 1 EventQueryHelper.kt\norg/opensearch/notifications/index/EventQueryHelper\n*L\n97#1:176,2\n119#1:178,2\n122#1:180,2\n136#1:182,2\n139#1:184,2\n*E\n"})
public final class EventQueryHelper {
    @NotNull
    public static final EventQueryHelper INSTANCE = new EventQueryHelper();
    @NotNull
    private static final String KEY_PREFIX = "event";
    @NotNull
    private static final String NESTED_PATH = "event.status_list";
    @NotNull
    private static final String KEYWORD_SUFFIX = "keyword";
    @NotNull
    private static final Set<String> METADATA_RANGE_FIELDS;
    @NotNull
    private static final Set<String> KEYWORD_FIELDS;
    @NotNull
    private static final Set<String> TEXT_FIELDS;
    @NotNull
    private static final Set<String> NESTED_KEYWORD_FIELDS;
    @NotNull
    private static final Set<String> NESTED_TEXT_FIELDS;
    @NotNull
    private static final Set<String> METADATA_FIELDS;
    @NotNull
    private static final Set<String> EVENT_FIELDS;
    @NotNull
    private static final Set<String> NESTED_FIELDS;
    @NotNull
    private static final Set<String> ALL_FIELDS;
    @NotNull
    private static final Set<String> FILTER_PARAMS;

    private EventQueryHelper() {
    }

    @NotNull
    public final Set<String> getFILTER_PARAMS() {
        return FILTER_PARAMS;
    }

    @NotNull
    public final String getSortField(@Nullable String sortField) {
        Object object;
        if (sortField == null) {
            object = "metadata.last_updated_time_ms";
        } else if (METADATA_RANGE_FIELDS.contains(sortField)) {
            object = "metadata." + sortField;
        } else if (KEYWORD_FIELDS.contains(sortField)) {
            object = "event." + sortField;
        } else if (TEXT_FIELDS.contains(sortField)) {
            object = "event." + sortField + ".keyword";
        } else {
            throw new OpenSearchStatusException("Sort on " + sortField + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        }
        return object;
    }

    public final void addQueryFilters(@NotNull BoolQueryBuilder query, @NotNull Map<String, String> filterParams) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter(filterParams, (String)"filterParams");
        BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery();
        Map<String, String> $this$forEach$iv = filterParams;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl = false;
            if (Intrinsics.areEqual((Object)"query", (Object)it.getKey())) {
                query.filter(INSTANCE.getQueryAllBuilder(it.getValue()));
                continue;
            }
            if (Intrinsics.areEqual((Object)"text_query", (Object)it.getKey())) {
                query.filter(INSTANCE.getTextQueryAllBuilder(it.getValue()));
                continue;
            }
            if (METADATA_RANGE_FIELDS.contains(it.getKey())) {
                query.filter(INSTANCE.getRangeQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (KEYWORD_FIELDS.contains(it.getKey())) {
                query.filter(INSTANCE.getTermsQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (TEXT_FIELDS.contains(it.getKey())) {
                query.filter(INSTANCE.getMatchQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (NESTED_KEYWORD_FIELDS.contains(it.getKey())) {
                nestedQuery.filter(INSTANCE.getTermsQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            if (NESTED_TEXT_FIELDS.contains(it.getKey())) {
                nestedQuery.filter(INSTANCE.getMatchQueryBuilder(it.getKey(), it.getValue()));
                continue;
            }
            throw new OpenSearchStatusException("Query on " + it.getKey() + " not acceptable", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        }
        List list = nestedQuery.filter();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"filter(...)");
        if (!((Collection)list).isEmpty()) {
            query.filter((QueryBuilder)QueryBuilders.nestedQuery((String)NESTED_PATH, (QueryBuilder)((QueryBuilder)nestedQuery), (ScoreMode)ScoreMode.None));
        }
    }

    private final QueryBuilder getQueryAllBuilder(String queryValue) {
        String it;
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        QueryStringQueryBuilder allNestedQuery = QueryBuilders.queryStringQuery((String)queryValue);
        Iterable $this$forEach$iv = EVENT_FIELDS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            allQuery.field("event." + it);
        }
        $this$forEach$iv = NESTED_FIELDS;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            allNestedQuery.field("event." + it);
        }
        NestedQueryBuilder nestedFieldQuery = QueryBuilders.nestedQuery((String)NESTED_PATH, (QueryBuilder)((QueryBuilder)allNestedQuery), (ScoreMode)ScoreMode.None);
        boolQuery.should((QueryBuilder)allQuery);
        boolQuery.should((QueryBuilder)nestedFieldQuery);
        Intrinsics.checkNotNull((Object)boolQuery);
        return (QueryBuilder)boolQuery;
    }

    private final QueryBuilder getTextQueryAllBuilder(String queryValue) {
        String it;
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        QueryStringQueryBuilder allQuery = QueryBuilders.queryStringQuery((String)queryValue);
        QueryStringQueryBuilder allNestedQuery = QueryBuilders.queryStringQuery((String)queryValue);
        Iterable $this$forEach$iv = TEXT_FIELDS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            allQuery.field("event." + it);
        }
        $this$forEach$iv = NESTED_TEXT_FIELDS;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            allNestedQuery.field("event." + it);
        }
        NestedQueryBuilder nestedFieldQuery = QueryBuilders.nestedQuery((String)NESTED_PATH, (QueryBuilder)((QueryBuilder)allNestedQuery), (ScoreMode)ScoreMode.None);
        boolQuery.should((QueryBuilder)allQuery);
        boolQuery.should((QueryBuilder)nestedFieldQuery);
        Intrinsics.checkNotNull((Object)boolQuery);
        return (QueryBuilder)boolQuery;
    }

    private final QueryBuilder getRangeQueryBuilder(String queryKey, String queryValue) {
        String[] stringArray = new String[]{".."};
        List range = StringsKt.split$default((CharSequence)queryValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return switch (range.size()) {
            case 1 -> {
                TermQueryBuilder v0 = QueryBuilders.termQuery((String)("metadata." + queryKey), (String)queryValue);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"termQuery(...)");
                yield (QueryBuilder)v0;
            }
            case 2 -> {
                RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)("metadata." + queryKey));
                rangeQuery.from(range.get(0));
                rangeQuery.to(range.get(1));
                RangeQueryBuilder var5_6 = rangeQuery;
                Intrinsics.checkNotNull((Object)var5_6);
                yield (QueryBuilder)var5_6;
            }
            default -> throw new OpenSearchStatusException("Invalid Range format " + queryValue + ", allowed format 'exact' or 'from..to'", RestStatus.NOT_ACCEPTABLE, new Object[0]);
        };
    }

    private final QueryBuilder getTermsQueryBuilder(String queryKey, String queryValue) {
        String[] stringArray = new String[]{","};
        TermsQueryBuilder termsQueryBuilder = QueryBuilders.termsQuery((String)("event." + queryKey), (Collection)StringsKt.split$default((CharSequence)queryValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)termsQueryBuilder, (String)"termsQuery(...)");
        return (QueryBuilder)termsQueryBuilder;
    }

    private final QueryBuilder getMatchQueryBuilder(String queryKey, String queryValue) {
        MatchQueryBuilder matchQueryBuilder = QueryBuilders.matchQuery((String)("event." + queryKey), (Object)queryValue);
        Intrinsics.checkNotNullExpressionValue((Object)matchQueryBuilder, (String)"matchQuery(...)");
        return (QueryBuilder)matchQueryBuilder;
    }

    static {
        Object[] objectArray = new String[]{"last_updated_time_ms", "created_time_ms"};
        METADATA_RANGE_FIELDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"event_source.reference_id", "event_source.severity", "event_source.tags.keyword", "event_source.title.keyword"};
        KEYWORD_FIELDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"event_source.tags", "event_source.title"};
        TEXT_FIELDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"status_list.config_id", "status_list.config_type", "status_list.email_recipient_status.delivery_status.status_code", "status_list.delivery_status.status_code", "status_list.config_name.keyword", "status_list.email_recipient_status.recipient.keyword", "status_list.email_recipient_status.delivery_status.status_text.keyword", "status_list.delivery_status.status_text.keyword"};
        NESTED_KEYWORD_FIELDS = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"status_list.config_name", "status_list.email_recipient_status.recipient", "status_list.email_recipient_status.delivery_status.status_text", "status_list.delivery_status.status_text"};
        NESTED_TEXT_FIELDS = SetsKt.setOf((Object[])objectArray);
        METADATA_FIELDS = METADATA_RANGE_FIELDS;
        EVENT_FIELDS = CollectionsKt.union((Iterable)KEYWORD_FIELDS, (Iterable)TEXT_FIELDS);
        NESTED_FIELDS = CollectionsKt.union((Iterable)NESTED_KEYWORD_FIELDS, (Iterable)NESTED_TEXT_FIELDS);
        ALL_FIELDS = CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)METADATA_FIELDS, (Iterable)EVENT_FIELDS), (Iterable)NESTED_FIELDS);
        objectArray = new String[]{"query", "text_query"};
        FILTER_PARAMS = CollectionsKt.union((Iterable)ALL_FIELDS, (Iterable)SetsKt.setOf((Object[])objectArray));
    }
}

