/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.sql.XAConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.ConnectionInitializationCallback;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OraclePooledConnectionConnectionPool;
import oracle.ucp.jdbc.proxy.ConnectionProxyFactory;
import oracle.ucp.jdbc.proxy.oracle.OracleConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;

public class OracleXAConnectionConnectionPool
extends OraclePooledConnectionConnectionPool {
    static final String CLASS_NAME = OracleXAConnectionConnectionPool.class.getName();
    private final ConnectionProxyFactory cpf = new OracleConnectionProxyFactory();

    public OracleXAConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter, diagnosticsCollector);
    }

    public OracleXAConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        this(connectionFactoryAdapter, (Diagnosable)DiagnosticsCollectorImpl.getCommon());
    }

    @Override
    public UniversalPooledConnection borrowConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        ConnectionInitializationCallback connInitCallback;
        UniversalPooledConnection upc = super.borrowConnection(cri);
        if (upc == null) {
            return upc;
        }
        Object xaconn = upc.getPhysicalConnection();
        if (xaconn == null) {
            return upc;
        }
        Connection pconn = null;
        try {
            pconn = ((OracleXAConnection)xaconn).getPhysicalHandle();
        }
        catch (SQLException ex) {
            this.trace(Level.WARNING, CLASS_NAME, "borrowConnection", "unable to obtain physical handle for XA connection", null, ex, new Object[0]);
        }
        if (pconn == null) {
            return upc;
        }
        if (this.getConnectionLabelingCallback() == null && (connInitCallback = this.getConnectionInitializationCallback()) != null && pconn != null) {
            try {
                connInitCallback.initialize(pconn);
            }
            catch (RuntimeException | SQLException exc) {
                upc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.returnConnection(upc);
                throw UCPErrorHandler.newUniversalConnectionPoolException(271, exc);
            }
        }
        return upc;
    }

    public XAConnection getXAConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        return (XAConnection)super.getPooledConnection(connectionRetrievalInfo);
    }

    public boolean returnXAConnection(XAConnection xaConnection) throws UniversalConnectionPoolException {
        return super.returnPooledConnection(xaConnection);
    }

    protected void validateConstructor(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        if (!(connectionFactoryAdapter instanceof XADataSourceConnectionFactoryAdapter)) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(106);
            throw ucpe;
        }
    }

    @Override
    protected Object getConnectionObjectForLabelingConfigure(UniversalPooledConnection upc) {
        JDBCUniversalPooledConnection jupc = (JDBCUniversalPooledConnection)upc;
        return this.getProxyFactory().proxyForXAConnection(this, jupc);
    }

    @Override
    public ConnectionProxyFactory getProxyFactory() {
        return this.cpf;
    }
}

