# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_niri_global_optspecs
	string join \n c/config= session h/help V/version
end

function __fish_niri_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_niri_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_niri_using_subcommand
	set -l cmd (__fish_niri_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c niri -n "__fish_niri_needs_command" -s c -l config -d 'Path to config file (default: `$XDG_CONFIG_HOME/niri/config.kdl`)' -r -F
complete -c niri -n "__fish_niri_needs_command" -l session -d 'Import environment globally to systemd and D-Bus, run D-Bus services'
complete -c niri -n "__fish_niri_needs_command" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c niri -n "__fish_niri_needs_command" -s V -l version -d 'Print version'
complete -c niri -n "__fish_niri_needs_command" -a "msg" -d 'Communicate with the running niri instance'
complete -c niri -n "__fish_niri_needs_command" -a "validate" -d 'Validate the config file'
complete -c niri -n "__fish_niri_needs_command" -a "panic" -d 'Cause a panic to check if the backtraces are good'
complete -c niri -n "__fish_niri_needs_command" -a "completions" -d 'Generate shell completions'
complete -c niri -n "__fish_niri_needs_command" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -s j -l json -d 'Format output as JSON'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "outputs" -d 'List connected outputs'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "workspaces" -d 'List workspaces'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "windows" -d 'List open windows'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "layers" -d 'List open layer-shell surfaces'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "keyboard-layouts" -d 'Get the configured keyboard layouts'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "focused-output" -d 'Print information about the focused output'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "focused-window" -d 'Print information about the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "pick-window" -d 'Pick a window with the mouse and print information about it'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "pick-color" -d 'Pick a color from the screen with the mouse'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "action" -d 'Perform an action'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "output" -d 'Change output configuration temporarily'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "event-stream" -d 'Start continuously receiving events from the compositor'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "version" -d 'Print the version of the running niri instance'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "request-error" -d 'Request an error from the running niri instance'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "overview-state" -d 'Print the overview state'
complete -c niri -n "__fish_niri_using_subcommand msg; and not __fish_seen_subcommand_from outputs workspaces windows layers keyboard-layouts focused-output focused-window pick-window pick-color action output event-stream version request-error overview-state help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from outputs" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from workspaces" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from windows" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from layers" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from keyboard-layouts" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from focused-output" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from focused-window" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from pick-window" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from pick-color" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "quit" -d 'Exit niri'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "power-off-monitors" -d 'Power off all monitors via DPMS'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "power-on-monitors" -d 'Power on all monitors via DPMS'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "spawn" -d 'Spawn a command'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "spawn-sh" -d 'Spawn a command through the shell'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "do-screen-transition" -d 'Do a screen transition'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "screenshot" -d 'Open the screenshot UI'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "screenshot-screen" -d 'Screenshot the focused screen'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "screenshot-window" -d 'Screenshot the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "toggle-keyboard-shortcuts-inhibit" -d 'Enable or disable the keyboard shortcuts inhibitor (if any) for the focused surface'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "close-window" -d 'Close the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "fullscreen-window" -d 'Toggle fullscreen on the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "toggle-windowed-fullscreen" -d 'Toggle windowed (fake) fullscreen on the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window" -d 'Focus a window by id'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-in-column" -d 'Focus a window in the focused column by index'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-previous" -d 'Focus the previously focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column-left" -d 'Focus the column to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column-right" -d 'Focus the column to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column-first" -d 'Focus the first column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column-last" -d 'Focus the last column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column-right-or-first" -d 'Focus the next column to the right, looping if at end'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column-left-or-last" -d 'Focus the next column to the left, looping if at start'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column" -d 'Focus a column by index'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-or-monitor-up" -d 'Focus the window or the monitor above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-or-monitor-down" -d 'Focus the window or the monitor below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column-or-monitor-left" -d 'Focus the column or the monitor to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-column-or-monitor-right" -d 'Focus the column or the monitor to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-down" -d 'Focus the window below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-up" -d 'Focus the window above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-down-or-column-left" -d 'Focus the window below or the column to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-down-or-column-right" -d 'Focus the window below or the column to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-up-or-column-left" -d 'Focus the window above or the column to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-up-or-column-right" -d 'Focus the window above or the column to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-or-workspace-down" -d 'Focus the window or the workspace below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-or-workspace-up" -d 'Focus the window or the workspace above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-top" -d 'Focus the topmost window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-bottom" -d 'Focus the bottommost window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-down-or-top" -d 'Focus the window below or the topmost window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-window-up-or-bottom" -d 'Focus the window above or the bottommost window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-left" -d 'Move the focused column to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-right" -d 'Move the focused column to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-first" -d 'Move the focused column to the start of the workspace'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-last" -d 'Move the focused column to the end of the workspace'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-left-or-to-monitor-left" -d 'Move the focused column to the left or to the monitor to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-right-or-to-monitor-right" -d 'Move the focused column to the right or to the monitor to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-index" -d 'Move the focused column to a specific index on its workspace'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-down" -d 'Move the focused window down in a column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-up" -d 'Move the focused window up in a column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-down-or-to-workspace-down" -d 'Move the focused window down in a column or to the workspace below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-up-or-to-workspace-up" -d 'Move the focused window up in a column or to the workspace above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "consume-or-expel-window-left" -d 'Consume or expel the focused window left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "consume-or-expel-window-right" -d 'Consume or expel the focused window right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "consume-window-into-column" -d 'Consume the window to the right into the focused column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "expel-window-from-column" -d 'Expel the focused window from the column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "swap-window-right" -d 'Swap focused window with one to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "swap-window-left" -d 'Swap focused window with one to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "toggle-column-tabbed-display" -d 'Toggle the focused column between normal and tabbed display'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "set-column-display" -d 'Set the display mode of the focused column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "center-column" -d 'Center the focused column on the screen'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "center-window" -d 'Center the focused window on the screen'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "center-visible-columns" -d 'Center all fully visible columns on the screen'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-workspace-down" -d 'Focus the workspace below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-workspace-up" -d 'Focus the workspace above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-workspace" -d 'Focus a workspace by reference (index or name)'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-workspace-previous" -d 'Focus the previous workspace'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-workspace-down" -d 'Move the focused window to the workspace below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-workspace-up" -d 'Move the focused window to the workspace above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-workspace" -d 'Move the focused window to a workspace by reference (index or name)'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-workspace-down" -d 'Move the focused column to the workspace below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-workspace-up" -d 'Move the focused column to the workspace above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-workspace" -d 'Move the focused column to a workspace by reference (index or name)'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-down" -d 'Move the focused workspace down'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-up" -d 'Move the focused workspace up'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-to-index" -d 'Move the focused workspace to a specific index on its monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "set-workspace-name" -d 'Set the name of the focused workspace'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "unset-workspace-name" -d 'Unset the name of the focused workspace'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-monitor-left" -d 'Focus the monitor to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-monitor-right" -d 'Focus the monitor to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-monitor-down" -d 'Focus the monitor below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-monitor-up" -d 'Focus the monitor above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-monitor-previous" -d 'Focus the previous monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-monitor-next" -d 'Focus the next monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-monitor" -d 'Focus a monitor by name'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-monitor-left" -d 'Move the focused window to the monitor to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-monitor-right" -d 'Move the focused window to the monitor to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-monitor-down" -d 'Move the focused window to the monitor below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-monitor-up" -d 'Move the focused window to the monitor above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-monitor-previous" -d 'Move the focused window to the previous monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-monitor-next" -d 'Move the focused window to the next monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-monitor" -d 'Move the focused window to a specific monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-monitor-left" -d 'Move the focused column to the monitor to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-monitor-right" -d 'Move the focused column to the monitor to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-monitor-down" -d 'Move the focused column to the monitor below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-monitor-up" -d 'Move the focused column to the monitor above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-monitor-previous" -d 'Move the focused column to the previous monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-monitor-next" -d 'Move the focused column to the next monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-column-to-monitor" -d 'Move the focused column to a specific monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "set-window-width" -d 'Change the width of the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "set-window-height" -d 'Change the height of the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "reset-window-height" -d 'Reset the height of the focused window back to automatic'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "switch-preset-column-width" -d 'Switch between preset column widths'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "switch-preset-column-width-back" -d 'Switch between preset column widths backwards'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "switch-preset-window-width" -d 'Switch between preset window widths'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "switch-preset-window-width-back" -d 'Switch between preset window widths backwards'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "switch-preset-window-height" -d 'Switch between preset window heights'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "switch-preset-window-height-back" -d 'Switch between preset window heights backwards'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "maximize-column" -d 'Toggle the maximized state of the focused column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "maximize-window-to-edges" -d 'Toggle the maximized-to-edges state of the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "set-column-width" -d 'Change the width of the focused column'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "expand-column-to-available-width" -d 'Expand the focused column to space not taken up by other fully visible columns'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "switch-layout" -d 'Switch between keyboard layouts'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "show-hotkey-overlay" -d 'Show the hotkey overlay'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-to-monitor-left" -d 'Move the focused workspace to the monitor to the left'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-to-monitor-right" -d 'Move the focused workspace to the monitor to the right'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-to-monitor-down" -d 'Move the focused workspace to the monitor below'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-to-monitor-up" -d 'Move the focused workspace to the monitor above'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-to-monitor-previous" -d 'Move the focused workspace to the previous monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-to-monitor-next" -d 'Move the focused workspace to the next monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-workspace-to-monitor" -d 'Move the focused workspace to a specific monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "toggle-debug-tint" -d 'Toggle a debug tint on windows'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "debug-toggle-opaque-regions" -d 'Toggle visualization of render element opaque regions'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "debug-toggle-damage" -d 'Toggle visualization of output damage'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "toggle-window-floating" -d 'Move the focused window between the floating and the tiling layout'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-floating" -d 'Move the focused window to the floating layout'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-window-to-tiling" -d 'Move the focused window to the tiling layout'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-floating" -d 'Switches focus to the floating layout'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "focus-tiling" -d 'Switches focus to the tiling layout'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "switch-focus-between-floating-and-tiling" -d 'Toggles the focus between the floating and the tiling layout'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "move-floating-window" -d 'Move the floating window on screen'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "toggle-window-rule-opacity" -d 'Toggle the opacity of the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "set-dynamic-cast-window" -d 'Set the dynamic cast target to the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "set-dynamic-cast-monitor" -d 'Set the dynamic cast target to the focused monitor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "clear-dynamic-cast-target" -d 'Clear the dynamic cast target, making it show nothing'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "toggle-overview" -d 'Toggle (open/close) the Overview'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "open-overview" -d 'Open the Overview'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "close-overview" -d 'Close the Overview'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "toggle-window-urgent" -d 'Toggle urgent status of a window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "set-window-urgent" -d 'Set urgent status of a window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "unset-window-urgent" -d 'Unset urgent status of a window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "load-config-file" -d 'Reload the config file'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from action" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "off" -d 'Turn off the output'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "on" -d 'Turn on the output'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "mode" -d 'Set the output mode'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "custom-mode" -d 'Set a custom output mode'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "modeline" -d 'Set a custom VESA CVT modeline'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "scale" -d 'Set the output scale'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "transform" -d 'Set the output transform'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "position" -d 'Set the output position'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "vrr" -d 'Set the variable refresh rate mode'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from output" -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from event-stream" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from version" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from request-error" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from overview-state" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "outputs" -d 'List connected outputs'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "workspaces" -d 'List workspaces'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "windows" -d 'List open windows'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "layers" -d 'List open layer-shell surfaces'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "keyboard-layouts" -d 'Get the configured keyboard layouts'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "focused-output" -d 'Print information about the focused output'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "focused-window" -d 'Print information about the focused window'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "pick-window" -d 'Pick a window with the mouse and print information about it'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "pick-color" -d 'Pick a color from the screen with the mouse'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "action" -d 'Perform an action'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "output" -d 'Change output configuration temporarily'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "event-stream" -d 'Start continuously receiving events from the compositor'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "version" -d 'Print the version of the running niri instance'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "request-error" -d 'Request an error from the running niri instance'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "overview-state" -d 'Print the overview state'
complete -c niri -n "__fish_niri_using_subcommand msg; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c niri -n "__fish_niri_using_subcommand validate" -s c -l config -d 'Path to config file (default: `$XDG_CONFIG_HOME/niri/config.kdl`)' -r -F
complete -c niri -n "__fish_niri_using_subcommand validate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c niri -n "__fish_niri_using_subcommand panic" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand completions" -s h -l help -d 'Print help'
complete -c niri -n "__fish_niri_using_subcommand help; and not __fish_seen_subcommand_from msg validate panic completions help" -f -a "msg" -d 'Communicate with the running niri instance'
complete -c niri -n "__fish_niri_using_subcommand help; and not __fish_seen_subcommand_from msg validate panic completions help" -f -a "validate" -d 'Validate the config file'
complete -c niri -n "__fish_niri_using_subcommand help; and not __fish_seen_subcommand_from msg validate panic completions help" -f -a "panic" -d 'Cause a panic to check if the backtraces are good'
complete -c niri -n "__fish_niri_using_subcommand help; and not __fish_seen_subcommand_from msg validate panic completions help" -f -a "completions" -d 'Generate shell completions'
complete -c niri -n "__fish_niri_using_subcommand help; and not __fish_seen_subcommand_from msg validate panic completions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "outputs" -d 'List connected outputs'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "workspaces" -d 'List workspaces'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "windows" -d 'List open windows'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "layers" -d 'List open layer-shell surfaces'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "keyboard-layouts" -d 'Get the configured keyboard layouts'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "focused-output" -d 'Print information about the focused output'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "focused-window" -d 'Print information about the focused window'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "pick-window" -d 'Pick a window with the mouse and print information about it'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "pick-color" -d 'Pick a color from the screen with the mouse'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "action" -d 'Perform an action'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "output" -d 'Change output configuration temporarily'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "event-stream" -d 'Start continuously receiving events from the compositor'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "version" -d 'Print the version of the running niri instance'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "request-error" -d 'Request an error from the running niri instance'
complete -c niri -n "__fish_niri_using_subcommand help; and __fish_seen_subcommand_from msg" -f -a "overview-state" -d 'Print the overview state'
