/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.ffmpeg.Output;
import com.github.kokorin.jaffree.ffmpeg.TcpOutput;
import com.github.kokorin.jaffree.net.PipeOutputNegotiator;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeOutput
extends TcpOutput<PipeOutput>
implements Output {
    private static final int DEFAULT_BUFFER_SIZE = 1000000;
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeOutput.class);

    protected PipeOutput(OutputStream destination, int bufferSize) {
        this(new PipeOutputNegotiator(destination, bufferSize));
    }

    protected PipeOutput(PipeOutputNegotiator negotiator) {
        super(negotiator);
        LOGGER.warn("It's recommended to use ChannelOutput since ffmpeg requires seekable output for many formats");
    }

    public static PipeOutput pumpTo(OutputStream destination) {
        return PipeOutput.pumpTo(destination, 1000000);
    }

    public static PipeOutput pumpTo(OutputStream destination, int bufferSize) {
        return new PipeOutput(destination, bufferSize);
    }
}

