/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree;

public enum LogLevel {
    QUIET(-8),
    PANIC(0),
    FATAL(8),
    ERROR(16),
    WARNING(24),
    INFO(32),
    VERBOSE(40),
    DEBUG(48),
    TRACE(56);

    private final int code;

    private LogLevel(int code) {
        this.code = code;
    }

    public int code() {
        return this.code;
    }

    public boolean isEqualOrHigher(LogLevel other) {
        return this.code() <= other.code();
    }

    public boolean isInfoOrHigher() {
        return this.isEqualOrHigher(INFO);
    }

    public boolean isErrorOrHigher() {
        return this.isEqualOrHigher(ERROR);
    }

    public static LogLevel fromCode(int code) {
        for (LogLevel level : LogLevel.values()) {
            if (level.code != code) continue;
            return level;
        }
        return null;
    }
}

