/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ-\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0002R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ6\u0010\u0010\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0082\u0010R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageQualifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirResolvedQualifierChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;)V", "checkNotAcceptedExperimentalities", "checkMarkerUsedAsQualifier", "checkContainingClasses", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;Lorg/jetbrains/kotlin/KtSourceElement;)V", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInUsageQualifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInUsageQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageQualifierChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n543#2,6:62\n2746#2,3:68\n*S KotlinDebug\n*F\n+ 1 FirOptInUsageQualifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirOptInUsageQualifierChecker\n*L\n44#1:62,6\n53#1:68,3\n*E\n"})
public final class FirOptInUsageQualifierChecker
extends FirExpressionChecker<FirResolvedQualifier> {
    @NotNull
    public static final FirOptInUsageQualifierChecker INSTANCE = new FirOptInUsageQualifierChecker();

    private FirOptInUsageQualifierChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirResolvedQualifier expression2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.checkNotAcceptedExperimentalities(context2, reporter, expression2);
        this.checkMarkerUsedAsQualifier(context2, reporter, expression2);
    }

    private final void checkNotAcceptedExperimentalities(CheckerContext context2, DiagnosticReporter reporter, FirResolvedQualifier expression2) {
        FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
        FirOptInUsageBaseChecker $this$checkNotAcceptedExperimentalities_u24lambda_u240 = FirOptInUsageBaseChecker.INSTANCE;
        boolean bl = false;
        Set<FirOptInUsageBaseChecker.Experimentality> experimentalities = $this$checkNotAcceptedExperimentalities_u24lambda_u240.loadExperimentalities(context2, (FirBasedSymbol)symbol, false, null);
        FirOptInUsageBaseChecker.reportNotAcceptedExperimentalities$default($this$checkNotAcceptedExperimentalities_u24lambda_u240, context2, reporter, experimentalities, expression2, null, 16, null);
    }

    private final void checkMarkerUsedAsQualifier(CheckerContext context2, DiagnosticReporter reporter, FirResolvedQualifier expression2) {
        FirElement parentExpression;
        Object object;
        FirElement firElement;
        block3: {
            List<FirElement> containingElements;
            List<FirElement> $this$lastOrNull$iv = containingElements = context2.getContainingElements();
            boolean $i$f$lastOrNull = false;
            ListIterator<FirElement> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                FirElement element$iv;
                FirElement it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(it instanceof FirQualifiedAccessExpression && Intrinsics.areEqual(((FirQualifiedAccessExpression)it).getDispatchReceiver(), expression2))) continue;
                firElement = element$iv;
                break block3;
            }
            firElement = null;
        }
        if ((object = (parentExpression = (FirElement)firElement)) == null || (object = object.getSource()) == null) {
            return;
        }
        Object source = object;
        FirClassLikeSymbol<?> firClassLikeSymbol = expression2.getSymbol();
        if (firClassLikeSymbol != null) {
            this.checkContainingClasses(context2, reporter, firClassLikeSymbol, (KtSourceElement)source);
        }
    }

    private final void checkContainingClasses(CheckerContext context2, DiagnosticReporter reporter, FirClassLikeSymbol<?> $this$checkContainingClasses, KtSourceElement source) {
        FirOptInUsageQualifierChecker firOptInUsageQualifierChecker = this;
        while (true) {
            Object object;
            if (FirOptInUsageBaseChecker.INSTANCE.isExperimentalMarker((FirClassLikeSymbol<?>)$this$checkContainingClasses, ((CheckerContext)context2).getSession())) {
                boolean bl;
                block7: {
                    Iterable $this$none$iv = ((CheckerContext)context2).getContainingDeclarations();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            FirBasedSymbol it = (FirBasedSymbol)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it, $this$checkContainingClasses)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), null, 8, null);
                }
            }
            if ((object = ClassMembersKt.getContainingClassLookupTag($this$checkContainingClasses)) == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeLookupTag)object, ((CheckerContext)context2).getSession())) == null) {
                return;
            }
            Object containingClassSymbol = object;
            FirOptInUsageQualifierChecker firOptInUsageQualifierChecker2 = firOptInUsageQualifierChecker;
            Object object2 = context2;
            DiagnosticReporter diagnosticReporter = reporter;
            KtSourceElement ktSourceElement = source;
            firOptInUsageQualifierChecker = firOptInUsageQualifierChecker2;
            context2 = object2;
            reporter = diagnosticReporter;
            $this$checkContainingClasses = containingClassSymbol;
            source = ktSourceElement;
        }
    }
}

