/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crl.infinispan;

import org.infinispan.Cache;
import org.keycloak.Config;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.crl.infinispan.InfinispanCacheCrlProvider;
import org.keycloak.crl.infinispan.X509CRLEntry;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.cache.CacheCrlProvider;
import org.keycloak.models.cache.CacheCrlProviderFactory;

public class InfinispanCacheCrlProviderFactory
implements CacheCrlProviderFactory {
    public static final String PROVIDER_ID = "infinispan";
    public static final String CRL_CLEAR_CACHE_EVENTS = "CRL_CLEAR_CACHE_EVENTS";
    private volatile Cache<String, X509CRLEntry> crlCache;

    public CacheCrlProvider create(KeycloakSession session) {
        this.lazyInit(session);
        return new InfinispanCacheCrlProvider(session, this.crlCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInit(KeycloakSession session) {
        if (this.crlCache == null) {
            InfinispanCacheCrlProviderFactory infinispanCacheCrlProviderFactory = this;
            synchronized (infinispanCacheCrlProviderFactory) {
                if (this.crlCache == null) {
                    this.crlCache = ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getCache("crl");
                    ClusterProvider cluster = (ClusterProvider)session.getProvider(ClusterProvider.class);
                    cluster.registerListener(CRL_CLEAR_CACHE_EVENTS, event -> this.crlCache.clear());
                }
            }
        }
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

