/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.stat.internal;

import java.io.Serializable;
import java.util.concurrent.atomic.LongAdder;
import org.hibernate.cache.spi.ExtendedStatisticsSupport;
import org.hibernate.cache.spi.Region;
import org.hibernate.stat.CacheRegionStatistics;

public class CacheRegionStatisticsImpl
implements CacheRegionStatistics,
Serializable {
    private final transient Region region;
    private final LongAdder hitCount = new LongAdder();
    private final LongAdder missCount = new LongAdder();
    private final LongAdder putCount = new LongAdder();
    private final LongAdder removeCount = new LongAdder();

    CacheRegionStatisticsImpl(Region region) {
        this.region = region;
    }

    @Override
    public String getRegionName() {
        return this.region.getName();
    }

    @Override
    public long getHitCount() {
        return this.hitCount.sum();
    }

    @Override
    public long getMissCount() {
        return this.missCount.sum();
    }

    @Override
    public long getPutCount() {
        return this.putCount.sum();
    }

    @Override
    public long getRemoveCount() {
        return this.removeCount.sum();
    }

    @Override
    public long getElementCountInMemory() {
        long l;
        Region region = this.region;
        if (region instanceof ExtendedStatisticsSupport) {
            ExtendedStatisticsSupport extended = (ExtendedStatisticsSupport)((Object)region);
            l = extended.getElementCountInMemory();
        } else {
            l = Long.MIN_VALUE;
        }
        return l;
    }

    @Override
    public long getElementCountOnDisk() {
        long l;
        Region region = this.region;
        if (region instanceof ExtendedStatisticsSupport) {
            ExtendedStatisticsSupport extended = (ExtendedStatisticsSupport)((Object)region);
            l = extended.getElementCountOnDisk();
        } else {
            l = Long.MIN_VALUE;
        }
        return l;
    }

    @Override
    public long getSizeInMemory() {
        long l;
        Region region = this.region;
        if (region instanceof ExtendedStatisticsSupport) {
            ExtendedStatisticsSupport extended = (ExtendedStatisticsSupport)((Object)region);
            l = extended.getSizeInMemory();
        } else {
            l = Long.MIN_VALUE;
        }
        return l;
    }

    void incrementHitCount() {
        this.hitCount.increment();
    }

    void incrementMissCount() {
        this.missCount.increment();
    }

    void incrementPutCount() {
        this.putCount.increment();
    }

    public void incrementRemoveCount() {
        this.removeCount.increment();
    }

    public String toString() {
        String buf = "CacheRegionStatistics[region=" + this.region.getName() + ",hitCount=" + String.valueOf(this.hitCount) + ",missCount=" + String.valueOf(this.missCount) + ",putCount=" + String.valueOf(this.putCount) + ",removeCount=" + String.valueOf(this.removeCount) + ",elementCountInMemory=" + this.getElementCountInMemory() + ",elementCountOnDisk=" + this.getElementCountOnDisk() + ",sizeInMemory=" + this.getSizeInMemory() + "]";
        return buf;
    }
}

