/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.CorrelatedTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;

public class SimpleFromClauseAccessImpl
implements FromClauseAccess {
    protected final FromClauseAccess parent;
    protected final Map<NavigablePath, TableGroup> tableGroupMap = new HashMap<NavigablePath, TableGroup>();

    public SimpleFromClauseAccessImpl() {
        this(null);
    }

    public SimpleFromClauseAccessImpl(FromClauseAccess parent) {
        this.parent = parent;
    }

    @Override
    public TableGroup findTableGroupOnCurrentFromClause(NavigablePath navigablePath) {
        return this.tableGroupMap.get(navigablePath);
    }

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        TableGroup tableGroup = this.tableGroupMap.get(navigablePath);
        if (tableGroup != null || this.parent == null) {
            return tableGroup;
        }
        return this.parent.findTableGroup(navigablePath);
    }

    @Override
    public @Nullable TableGroup findTableGroupByIdentificationVariable(String identificationVariable) {
        for (TableGroup tableGroup : this.tableGroupMap.values()) {
            if (tableGroup.findTableReference(identificationVariable) == null) continue;
            return tableGroup;
        }
        return this.parent == null ? null : this.parent.findTableGroupByIdentificationVariable(identificationVariable);
    }

    @Override
    public TableGroup findTableGroupForGetOrCreate(NavigablePath navigablePath) {
        NavigableRole navigableRole;
        TableGroup localTableGroup = this.tableGroupMap.get(navigablePath);
        if (localTableGroup != null || this.parent == null) {
            return localTableGroup;
        }
        TableGroup tableGroup = this.parent.findTableGroup(navigablePath);
        if (tableGroup != null && navigablePath.getParent() != null && (navigableRole = tableGroup.getModelPart().getNavigableRole()).getParent() != null) {
            NavigableRole parentRole = navigableRole.getParent();
            NavigablePath parentPath = navigablePath.getParent();
            while (parentRole.getParent() != null) {
                parentRole = parentRole.getParent();
                parentPath = parentPath.getParent();
            }
            TableGroup parentFound = this.parent.findTableGroup(parentPath);
            if (parentFound == null || this.getCorrelatedTableGroup(parentFound) == this.getCorrelatedTableGroup(this.tableGroupMap.get(parentPath))) {
                return tableGroup;
            }
            return null;
        }
        return tableGroup;
    }

    public TableGroup findTableGroupForGetOrCreate(NavigablePath navigablePath, boolean allowLeftJoins) {
        TableGroup tableGroup = this.findTableGroupForGetOrCreate(navigablePath);
        if (!allowLeftJoins && tableGroup != null && navigablePath.getParent() != null && CollectionPart.Nature.fromNameExact(navigablePath.getLocalName()) == null) {
            TableGroupJoin join = this.findTableGroup(navigablePath.getParent()).findTableGroupJoin(tableGroup);
            return join != null && join.getJoinType() == SqlAstJoinType.LEFT ? null : tableGroup;
        }
        return tableGroup;
    }

    private TableGroup getCorrelatedTableGroup(TableGroup tableGroup) {
        TableGroup tableGroup2;
        if (tableGroup instanceof CorrelatedTableGroup) {
            CorrelatedTableGroup correlatedTableGroup = (CorrelatedTableGroup)tableGroup;
            tableGroup2 = this.getCorrelatedTableGroup(correlatedTableGroup.getCorrelatedTableGroup());
        } else {
            tableGroup2 = tableGroup;
        }
        return tableGroup2;
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        TableGroup previous = this.tableGroupMap.put(navigablePath, tableGroup);
    }
}

