/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.mutation.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.mutation.JdbcValueBindings;
import org.hibernate.engine.jdbc.mutation.OperationResultChecker;
import org.hibernate.engine.jdbc.mutation.ParameterUsage;
import org.hibernate.engine.jdbc.mutation.TableInclusionChecker;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementDetails;
import org.hibernate.engine.jdbc.mutation.group.PreparedStatementGroup;
import org.hibernate.engine.jdbc.mutation.internal.AbstractMutationExecutor;
import org.hibernate.engine.jdbc.mutation.internal.JdbcValueBindingsImpl;
import org.hibernate.engine.jdbc.mutation.internal.ModelMutationHelper;
import org.hibernate.engine.jdbc.mutation.spi.BatchKeyAccess;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.generator.values.GeneratedValuesMutationDelegate;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.model.EntityMutationOperationGroup;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationType;
import org.hibernate.sql.model.PreparableMutationOperation;
import org.hibernate.sql.model.SelfExecutingUpdateOperation;
import org.hibernate.sql.model.TableMapping;
import org.hibernate.sql.model.ValuesAnalysis;
import org.hibernate.sql.model.jdbc.JdbcValueDescriptor;

public class MutationExecutorStandard
extends AbstractMutationExecutor
implements JdbcValueBindingsImpl.JdbcValueDescriptorAccess {
    private final MutationOperationGroup mutationOperationGroup;
    private final Batch batch;
    private final PreparedStatementGroup nonBatchedStatementGroup;
    private final GeneratedValuesMutationDelegate generatedValuesDelegate;
    private final List<SelfExecutingUpdateOperation> selfExecutingMutations;
    private final JdbcValueBindingsImpl valueBindings;
    private final Map<String, StatementLocation> statementLocationMap = new HashMap<String, StatementLocation>();

    public MutationExecutorStandard(MutationOperationGroup mutationOperationGroup, BatchKeyAccess batchKeySupplier, int batchSize, SharedSessionContractImplementor session) {
        this.mutationOperationGroup = mutationOperationGroup;
        this.generatedValuesDelegate = mutationOperationGroup.asEntityMutationOperationGroup() != null ? mutationOperationGroup.asEntityMutationOperationGroup().getMutationDelegate() : null;
        BatchKey batchKey = batchKeySupplier.getBatchKey();
        ArrayList<PreparableMutationOperation> batchedJdbcMutations = null;
        ArrayList<PreparableMutationOperation> nonBatchedJdbcMutations = null;
        ArrayList<SelfExecutingUpdateOperation> selfExecutingMutations = null;
        boolean hasAnyNonBatchedJdbcOperations = false;
        for (int i = mutationOperationGroup.getNumberOfOperations() - 1; i >= 0; --i) {
            MutationOperation operation = mutationOperationGroup.getOperation(i);
            if (operation instanceof SelfExecutingUpdateOperation) {
                SelfExecutingUpdateOperation selfExecutingUpdateOperation = (SelfExecutingUpdateOperation)operation;
                if (selfExecutingMutations == null) {
                    selfExecutingMutations = new ArrayList<SelfExecutingUpdateOperation>();
                }
                selfExecutingMutations.add(0, selfExecutingUpdateOperation);
                continue;
            }
            PreparableMutationOperation preparableMutationOperation = (PreparableMutationOperation)operation;
            TableMapping tableDetails = operation.getTableDetails();
            boolean canBeBatched = tableDetails.isIdentifierTable() && hasAnyNonBatchedJdbcOperations ? false : preparableMutationOperation.canBeBatched(batchKey, batchSize);
            if (canBeBatched) {
                if (batchedJdbcMutations == null) {
                    batchedJdbcMutations = new ArrayList<PreparableMutationOperation>();
                }
                batchedJdbcMutations.add(0, preparableMutationOperation);
                this.statementLocationMap.put(tableDetails.getTableName(), StatementLocation.BATCHED);
                continue;
            }
            hasAnyNonBatchedJdbcOperations = true;
            if (nonBatchedJdbcMutations == null) {
                nonBatchedJdbcMutations = new ArrayList<PreparableMutationOperation>();
            }
            nonBatchedJdbcMutations.add(0, preparableMutationOperation);
            this.statementLocationMap.put(tableDetails.getTableName(), StatementLocation.NON_BATCHED);
        }
        if (batchedJdbcMutations == null || batchedJdbcMutations.isEmpty()) {
            this.batch = null;
        } else {
            assert (this.generatedValuesDelegate == null) : "Unsupported batched mutation for entity target with generated values delegate";
            ArrayList<PreparableMutationOperation> batchedMutationsRef = batchedJdbcMutations;
            this.batch = session.getJdbcCoordinator().getBatch(batchKey, batchSize, () -> ModelMutationHelper.toPreparedStatementGroup(mutationOperationGroup.getMutationType(), mutationOperationGroup.getMutationTarget(), null, batchedMutationsRef, session));
            assert (this.batch != null);
        }
        this.nonBatchedStatementGroup = ModelMutationHelper.toPreparedStatementGroup(mutationOperationGroup.getMutationType(), mutationOperationGroup.getMutationTarget(), this.generatedValuesDelegate, nonBatchedJdbcMutations, session);
        this.selfExecutingMutations = selfExecutingMutations;
        this.valueBindings = new JdbcValueBindingsImpl(mutationOperationGroup.getMutationType(), mutationOperationGroup.getMutationTarget(), this, session);
        if (CollectionHelper.isNotEmpty(nonBatchedJdbcMutations) || CollectionHelper.isNotEmpty(selfExecutingMutations)) {
            this.prepareForNonBatchedWork(batchKey, session);
        }
    }

    protected PreparedStatementGroup getBatchedPreparedStatementGroup() {
        return this.batch != null ? this.batch.getStatementGroup() : null;
    }

    protected PreparedStatementGroup getNonBatchedStatementGroup() {
        return this.nonBatchedStatementGroup;
    }

    protected List<SelfExecutingUpdateOperation> getSelfExecutingMutations() {
        return this.selfExecutingMutations;
    }

    @Override
    public JdbcValueBindings getJdbcValueBindings() {
        return this.valueBindings;
    }

    @Override
    public JdbcValueDescriptor resolveValueDescriptor(String tableName, String columnName, ParameterUsage usage) {
        return this.mutationOperationGroup.getOperation(tableName).findValueDescriptor(columnName, usage);
    }

    @Override
    public PreparedStatementDetails getPreparedStatementDetails(String tableName) {
        StatementLocation statementLocation = this.statementLocationMap.get(tableName);
        if (statementLocation == null) {
            return null;
        }
        if (statementLocation == StatementLocation.BATCHED) {
            assert (this.batch != null);
            return this.batch.getStatementGroup().getPreparedStatementDetails(tableName);
        }
        if (statementLocation == StatementLocation.NON_BATCHED) {
            assert (this.nonBatchedStatementGroup != null);
            return this.nonBatchedStatementGroup.getPreparedStatementDetails(tableName);
        }
        return null;
    }

    @Override
    public void release() {
        this.nonBatchedStatementGroup.release();
    }

    @Override
    protected GeneratedValues performNonBatchedOperations(Object modelReference, ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, OperationResultChecker resultChecker, SharedSessionContractImplementor session) {
        GeneratedValues generatedValues;
        if (this.nonBatchedStatementGroup == null || this.nonBatchedStatementGroup.getNumberOfStatements() <= 0) {
            return null;
        }
        if (this.generatedValuesDelegate != null) {
            EntityMutationOperationGroup entityGroup = this.mutationOperationGroup.asEntityMutationOperationGroup();
            EntityMutationTarget entityTarget = entityGroup.getMutationTarget();
            PreparedStatementDetails details = this.nonBatchedStatementGroup.getPreparedStatementDetails(entityTarget.getIdentifierTableName());
            generatedValues = this.generatedValuesDelegate.performMutation(details, this.valueBindings, modelReference, session);
            Object id = entityGroup.getMutationType() == MutationType.INSERT && details.getMutatingTableDetails().isIdentifierTable() ? generatedValues.getGeneratedValue(entityTarget.getTargetPart().getIdentifierMapping()) : null;
            this.nonBatchedStatementGroup.forEachStatement((tableName, statementDetails) -> {
                if (!statementDetails.getMutatingTableDetails().isIdentifierTable()) {
                    this.performNonBatchedMutation((PreparedStatementDetails)statementDetails, id, this.valueBindings, inclusionChecker, resultChecker, session);
                }
            });
        } else {
            generatedValues = null;
            this.nonBatchedStatementGroup.forEachStatement((tableName, statementDetails) -> this.performNonBatchedMutation((PreparedStatementDetails)statementDetails, null, this.valueBindings, inclusionChecker, resultChecker, session));
        }
        return generatedValues;
    }

    @Override
    protected void performSelfExecutingOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, SharedSessionContractImplementor session) {
        if (this.selfExecutingMutations == null || this.selfExecutingMutations.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.selfExecutingMutations.size(); ++i) {
            SelfExecutingUpdateOperation operation = this.selfExecutingMutations.get(i);
            if (!inclusionChecker.include(operation.getTableDetails())) continue;
            operation.performMutation(this.valueBindings, valuesAnalysis, session);
        }
    }

    @Override
    protected void performBatchedOperations(ValuesAnalysis valuesAnalysis, TableInclusionChecker inclusionChecker, Batch.StaleStateMapper staleStateMapper) {
        if (this.batch == null) {
            return;
        }
        this.batch.addToBatch(this.valueBindings, inclusionChecker, staleStateMapper);
    }

    public String toString() {
        return String.format(Locale.ROOT, "MutationExecutorStandard(`%s:%s`)", this.mutationOperationGroup.getMutationType().name(), this.mutationOperationGroup.getMutationTarget().getRolePath());
    }

    private static enum StatementLocation {
        BATCHED,
        NON_BATCHED;

    }
}

