/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.lock.internal;

import jakarta.persistence.Timeout;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;

public class H2LockingSupport
implements LockingSupport,
LockingSupport.Metadata {
    public static final H2LockingSupport LEGACY_INSTANCE = new H2LockingSupport(false);
    public static final H2LockingSupport INSTANCE = new H2LockingSupport(true);
    private final boolean supportsForUpdateOptions;

    private H2LockingSupport(boolean supportsForUpdateOptions) {
        this.supportsForUpdateOptions = supportsForUpdateOptions;
    }

    @Override
    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    @Override
    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.IGNORED;
    }

    @Override
    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case 0 -> {
                if (this.supportsForUpdateOptions) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -2 -> {
                if (this.supportsForUpdateOptions) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -1 -> LockTimeoutType.QUERY;
            default -> LockTimeoutType.NONE;
        };
    }

    @Override
    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return ConnectionLockTimeoutStrategy.NONE;
    }
}

