/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import java.util.Objects;

public class ConfigSourceName
implements Comparable<ConfigSourceName> {
    private static final String APPLICATION_PROPERTIES_CONFIG_SOURCE = "PropertiesConfigSource[source=application.properties]";
    private static final String SYSTEM_PROPERTIES_CONFIG_SOURCE = "SysPropConfigSource";
    private static final String ENVIRONMENT_CONFIG_SOURCE = "EnvConfigSource";
    private static final String PROPERTIES_CONFIG_SOURCE = "PropertiesConfigSource";
    private static final String DEFAULT_VALUES = "default values";
    private static final String SOURCE = "[source=";
    private static final int SOURCE_LENGTH = "[source=".length();
    private int order;
    private String name;
    private String displayName;
    private int ordinal;
    private boolean editable;
    private boolean showEnvVarName;

    public ConfigSourceName() {
    }

    public ConfigSourceName(String name, int ordinal) {
        if (name == null) {
            name = "Other";
        }
        this.name = name;
        this.ordinal = ordinal;
        this.order = this.createOrder();
        this.displayName = this.createDisplayName();
        this.editable = this.createEditable();
        this.showEnvVarName = !name.equals(ENVIRONMENT_CONFIG_SOURCE);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isShowEnvVarName() {
        return this.showEnvVarName;
    }

    public void setShowEnvVarName(boolean showEnvVarName) {
        this.showEnvVarName = showEnvVarName;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    private String createDisplayName() {
        if (this.name.contains(SOURCE)) {
            return this.name.substring(this.name.indexOf(SOURCE) + SOURCE_LENGTH, this.name.length() - 1);
        }
        if (this.name.equals(DEFAULT_VALUES)) {
            return "Default values";
        }
        if (this.name.equals(SYSTEM_PROPERTIES_CONFIG_SOURCE)) {
            return "System properties";
        }
        if (this.name.equals(ENVIRONMENT_CONFIG_SOURCE)) {
            return "Environment variables";
        }
        return this.name;
    }

    private int createOrder() {
        if (this.name.equals(APPLICATION_PROPERTIES_CONFIG_SOURCE)) {
            return 1;
        }
        if (this.name.startsWith(PROPERTIES_CONFIG_SOURCE)) {
            return 2;
        }
        if (this.name.equals(DEFAULT_VALUES)) {
            return 3;
        }
        if (this.name.equals(SYSTEM_PROPERTIES_CONFIG_SOURCE)) {
            return 9;
        }
        if (this.name.equals(ENVIRONMENT_CONFIG_SOURCE)) {
            return 10;
        }
        return 5;
    }

    private boolean createEditable() {
        return this.ordinal <= 250;
    }

    @Override
    public int compareTo(ConfigSourceName o) {
        return Integer.compare(this.order, o.order);
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigSourceName other = (ConfigSourceName)obj;
        return Objects.equals(this.name, other.name);
    }

    public String toString() {
        return this.displayName;
    }
}

