/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.file;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MutinyDelegate;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;

@MutinyGen(value=io.vertx.core.file.AsyncFileLock.class)
public class AsyncFileLock
implements MutinyDelegate {
    public static final TypeArg<AsyncFileLock> __TYPE_ARG = new TypeArg(obj -> new AsyncFileLock((io.vertx.core.file.AsyncFileLock)obj), AsyncFileLock::getDelegate);
    private final io.vertx.core.file.AsyncFileLock delegate;

    public AsyncFileLock(io.vertx.core.file.AsyncFileLock delegate) {
        this.delegate = delegate;
    }

    public AsyncFileLock(Object delegate) {
        this.delegate = (io.vertx.core.file.AsyncFileLock)delegate;
    }

    AsyncFileLock() {
        this.delegate = null;
    }

    public io.vertx.core.file.AsyncFileLock getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFileLock that = (AsyncFileLock)o;
        return this.delegate.equals((Object)that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public long position() {
        long ret = this.delegate.position();
        return ret;
    }

    public long size() {
        long ret = this.delegate.size();
        return ret;
    }

    public boolean isShared() {
        boolean ret = this.delegate.isShared();
        return ret;
    }

    public boolean overlaps(long position, long size) {
        boolean ret = this.delegate.overlaps(position, size);
        return ret;
    }

    public boolean isValidBlocking() {
        boolean ret = this.delegate.isValidBlocking();
        return ret;
    }

    @CheckReturnValue
    public Uni<Boolean> isValid() {
        return AsyncResultUni.toUni(handler -> this.delegate.isValid(handler));
    }

    public Boolean isValidAndAwait() {
        return (Boolean)this.isValid().await().indefinitely();
    }

    public void isValidAndForget() {
        this.isValid().subscribe().with(UniHelper.NOOP);
    }

    public void releaseBlocking() {
        this.delegate.releaseBlocking();
    }

    @CheckReturnValue
    public Uni<Void> release() {
        return AsyncResultUni.toUni(handler -> this.delegate.release(handler));
    }

    public Void releaseAndAwait() {
        return (Void)this.release().await().indefinitely();
    }

    public void releaseAndForget() {
        this.release().subscribe().with(UniHelper.NOOP);
    }

    public static AsyncFileLock newInstance(io.vertx.core.file.AsyncFileLock arg) {
        return arg != null ? new AsyncFileLock(arg) : null;
    }
}

