/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import java.util.Objects;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.model.domain.TreatableDomainType;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmRenderContext;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmTreatableDomainType;
import org.hibernate.query.sqm.tree.from.SqmTreatedAttributeJoin;
import org.hibernate.spi.NavigablePath;

public class SqmTreatedBagJoin<L, R, S extends R>
extends SqmBagJoin<L, S>
implements SqmTreatedAttributeJoin<L, R, S> {
    private final SqmBagJoin<L, R> wrappedPath;
    private final SqmTreatableDomainType<S> treatTarget;

    public SqmTreatedBagJoin(SqmBagJoin<L, R> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias) {
        this(wrappedPath, treatTarget, alias, false);
    }

    public SqmTreatedBagJoin(SqmBagJoin<L, R> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), wrappedPath.getNavigablePath().append(CollectionPart.Nature.ELEMENT.getName()).treatAs(treatTarget.getTypeName(), alias), wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), fetched, (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    private SqmTreatedBagJoin(NavigablePath navigablePath, SqmBagJoin<L, R> wrappedPath, SqmTreatableDomainType<S> treatTarget, String alias, boolean fetched) {
        super(wrappedPath.getLhs(), navigablePath, wrappedPath.getAttribute(), alias, wrappedPath.getSqmJoinType(), wrappedPath.isFetched(), (NodeBuilder)wrappedPath.nodeBuilder());
        this.treatTarget = treatTarget;
        this.wrappedPath = wrappedPath;
    }

    @Override
    public SqmTreatedBagJoin<L, R, S> copy(SqmCopyContext context) {
        SqmTreatedBagJoin existing = context.getCopy(this);
        if (existing != null) {
            return existing;
        }
        SqmTreatedBagJoin<L, R, S> path = context.registerCopy(this, new SqmTreatedBagJoin<L, R, S>(this.getNavigablePath(), this.wrappedPath.copy(context), this.treatTarget, this.getExplicitAlias(), this.isFetched()));
        this.copyTo(path, context);
        return path;
    }

    public SqmBagJoin<L, R> getWrappedPath() {
        return this.wrappedPath;
    }

    @Override
    public TreatableDomainType<S> getTreatTarget() {
        return this.treatTarget;
    }

    @Override
    public SqmBindableType<S> getNodeType() {
        return this.treatTarget;
    }

    @Override
    public SqmTreatableDomainType<S> getReferencedPathSource() {
        return this.treatTarget;
    }

    @Override
    public SqmPathSource<S> getResolvedModel() {
        return this.treatTarget;
    }

    @Override
    public void appendHqlString(StringBuilder hql, SqmRenderContext context) {
        hql.append("treat(");
        this.wrappedPath.appendHqlString(hql, context);
        hql.append(" as ");
        hql.append(this.treatTarget.getTypeName());
        hql.append(')');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (!(object instanceof SqmTreatedBagJoin)) return false;
        SqmTreatedBagJoin that = (SqmTreatedBagJoin)object;
        if (!Objects.equals(this.getExplicitAlias(), that.getExplicitAlias())) return false;
        if (!Objects.equals(this.treatTarget.getTypeName(), that.treatTarget.getTypeName())) return false;
        if (!Objects.equals(this.wrappedPath.getNavigablePath(), that.wrappedPath.getNavigablePath())) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.treatTarget.getTypeName(), this.wrappedPath.getNavigablePath());
    }

    @Override
    public SqmTreatedBagJoin<L, R, S> on(JpaExpression<Boolean> restriction) {
        return (SqmTreatedBagJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmTreatedBagJoin<L, R, S> on(Expression<Boolean> restriction) {
        return (SqmTreatedBagJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmTreatedBagJoin<L, R, S> on(JpaPredicate ... restrictions) {
        return (SqmTreatedBagJoin)super.on(restrictions);
    }

    @Override
    public SqmTreatedBagJoin<L, R, S> on(Predicate ... restrictions) {
        return (SqmTreatedBagJoin)super.on(restrictions);
    }
}

