/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.hash4j.hashing;

import com.dynatrace.hash4j.hashing.AbstractHashStream64;
import com.dynatrace.hash4j.hashing.AbstractHasher64;
import com.dynatrace.hash4j.hashing.HashStream64;
import com.dynatrace.hash4j.internal.ByteArrayUtil;
import com.dynatrace.hash4j.internal.UnsignedMultiplyUtil;

abstract class AbstractKomihash
implements AbstractHasher64 {
    protected final long seed1;
    protected final long seed2;
    protected final long seed3;
    protected final long seed4;
    protected final long seed5;
    protected final long seed6;
    protected final long seed7;
    protected final long seed8;

    protected AbstractKomihash(long seed) {
        long s1 = 0x243F6A8885A308D3L ^ seed & 0x5555555555555555L;
        long s5 = 0x452821E638D01377L ^ seed & 0xAAAAAAAAAAAAAAAAL;
        long l = s1 * s5;
        long h = UnsignedMultiplyUtil.unsignedMultiplyHigh(s1, s5);
        this.seed1 = s1 = (s5 += h) ^ l;
        this.seed2 = 0x13198A2E03707344L ^ s1;
        this.seed3 = 0xA4093822299F31D0L ^ s1;
        this.seed4 = 0x82EFA98EC4E6C89L ^ s1;
        this.seed5 = s5;
        this.seed6 = 0xBE5466CF34E90C6CL ^ s5;
        this.seed7 = 0xC0AC29B7C97C50DDL ^ s5;
        this.seed8 = 0x3F84D5B5B5470917L ^ s5;
    }

    protected static long finish(long r2h, long r2l, long see5) {
        long see1 = (see5 += UnsignedMultiplyUtil.unsignedMultiplyHigh(r2l, r2h)) ^ r2l * r2h;
        r2h = UnsignedMultiplyUtil.unsignedMultiplyHigh(see1, see5);
        see1 *= see5;
        return see1 ^= (see5 += r2h);
    }

    protected abstract class HashStreamImpl
    implements AbstractHashStream64 {
        protected final byte[] buffer = new byte[71];
        protected long byteCount = 0L;
        protected long see1;
        protected long see2;
        protected long see3;
        protected long see4;
        protected long see5;
        protected long see6;
        protected long see7;
        protected long see8;

        protected HashStreamImpl() {
            this.see1 = AbstractKomihash.this.seed1;
            this.see2 = AbstractKomihash.this.seed2;
            this.see3 = AbstractKomihash.this.seed3;
            this.see4 = AbstractKomihash.this.seed4;
            this.see5 = AbstractKomihash.this.seed5;
            this.see6 = AbstractKomihash.this.seed6;
            this.see7 = AbstractKomihash.this.seed7;
            this.see8 = AbstractKomihash.this.seed8;
        }

        @Override
        public HashStream64 reset() {
            this.see1 = AbstractKomihash.this.seed1;
            this.see2 = AbstractKomihash.this.seed2;
            this.see3 = AbstractKomihash.this.seed3;
            this.see4 = AbstractKomihash.this.seed4;
            this.see5 = AbstractKomihash.this.seed5;
            this.see6 = AbstractKomihash.this.seed6;
            this.see7 = AbstractKomihash.this.seed7;
            this.see8 = AbstractKomihash.this.seed8;
            this.byteCount = 0L;
            return this;
        }

        @Override
        public HashStream64 putByte(byte v) {
            this.buffer[(int)(this.byteCount & 0x3FL)] = v;
            if ((this.byteCount & 0x3FL) >= 63L) {
                this.processBuffer();
            }
            ++this.byteCount;
            return this;
        }

        @Override
        public HashStream64 putShort(short v) {
            ByteArrayUtil.setShort(this.buffer, (int)(this.byteCount & 0x3FL), v);
            if ((this.byteCount & 0x3FL) >= 62L) {
                this.processBuffer();
                this.buffer[0] = (byte)(v >>> (int)(-(this.byteCount << 3)));
            }
            this.byteCount += 2L;
            return this;
        }

        @Override
        public HashStream64 putChar(char v) {
            ByteArrayUtil.setChar(this.buffer, (int)(this.byteCount & 0x3FL), v);
            if ((this.byteCount & 0x3FL) >= 62L) {
                this.processBuffer();
                this.buffer[0] = (byte)(v >>> (int)(-(this.byteCount << 3)));
            }
            this.byteCount += 2L;
            return this;
        }

        @Override
        public HashStream64 putInt(int v) {
            ByteArrayUtil.setInt(this.buffer, (int)(this.byteCount & 0x3FL), v);
            if ((this.byteCount & 0x3FL) >= 60L) {
                this.processBuffer();
                ByteArrayUtil.setInt(this.buffer, 0, v >>> (int)(-(this.byteCount << 3)));
            }
            this.byteCount += 4L;
            return this;
        }

        @Override
        public HashStream64 putLong(long v) {
            ByteArrayUtil.setLong(this.buffer, (int)(this.byteCount & 0x3FL), v);
            if ((this.byteCount & 0x3FL) >= 56L) {
                this.processBuffer();
                ByteArrayUtil.setLong(this.buffer, 0, v >>> (int)(-(this.byteCount << 3)));
            }
            this.byteCount += 8L;
            return this;
        }

        @Override
        public HashStream64 putBytes(byte[] b, int off, int len) {
            int offset = (int)this.byteCount & 0x3F;
            this.byteCount += (long)len;
            int x = 64 - offset;
            if (len >= x) {
                if (offset != 0) {
                    System.arraycopy(b, off, this.buffer, offset, x);
                    len -= x;
                    off += x;
                    offset = 0;
                    this.processBuffer();
                }
                while (len > 63) {
                    long b0 = ByteArrayUtil.getLong(b, off);
                    long b1 = ByteArrayUtil.getLong(b, off + 8);
                    long b2 = ByteArrayUtil.getLong(b, off + 16);
                    long b3 = ByteArrayUtil.getLong(b, off + 24);
                    long b4 = ByteArrayUtil.getLong(b, off + 32);
                    long b5 = ByteArrayUtil.getLong(b, off + 40);
                    long b6 = ByteArrayUtil.getLong(b, off + 48);
                    long b7 = ByteArrayUtil.getLong(b, off + 56);
                    this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
                    off += 64;
                    len -= 64;
                }
                if (len == 0) {
                    this.buffer[63] = b[off - 1];
                }
            }
            System.arraycopy(b, off, this.buffer, offset, len);
            return this;
        }

        @Override
        public HashStream64 putChars(CharSequence s) {
            int remainingChars = s.length();
            int offset = (int)this.byteCount & 0x3F;
            this.byteCount += (long)remainingChars << 1;
            int off = 0;
            int x = 65 - offset >>> 1;
            if (remainingChars >= x) {
                if (offset > 1) {
                    ByteArrayUtil.copyCharsToByteArray(s, 0, this.buffer, offset, x);
                    remainingChars -= x;
                    off = x;
                    this.processBuffer();
                    if ((offset &= 1) != 0) {
                        this.buffer[0] = this.buffer[64];
                    }
                }
                if (remainingChars >= 32) {
                    if (offset == 0) {
                        long b7;
                        do {
                            long b0 = ByteArrayUtil.getLong(s, off);
                            long b1 = ByteArrayUtil.getLong(s, off + 4);
                            long b2 = ByteArrayUtil.getLong(s, off + 8);
                            long b3 = ByteArrayUtil.getLong(s, off + 12);
                            long b4 = ByteArrayUtil.getLong(s, off + 16);
                            long b5 = ByteArrayUtil.getLong(s, off + 20);
                            long b6 = ByteArrayUtil.getLong(s, off + 24);
                            b7 = ByteArrayUtil.getLong(s, off + 28);
                            this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
                            off += 32;
                        } while ((remainingChars -= 32) >= 32);
                        this.buffer[63] = (byte)(b7 >>> 56);
                    } else {
                        long z = (long)this.buffer[0] & 0xFFL;
                        do {
                            long b0 = ByteArrayUtil.getLong(s, off);
                            long b1 = ByteArrayUtil.getLong(s, off + 4);
                            long b2 = ByteArrayUtil.getLong(s, off + 8);
                            long b3 = ByteArrayUtil.getLong(s, off + 12);
                            long b4 = ByteArrayUtil.getLong(s, off + 16);
                            long b5 = ByteArrayUtil.getLong(s, off + 20);
                            long b6 = ByteArrayUtil.getLong(s, off + 24);
                            long b7 = ByteArrayUtil.getLong(s, off + 28);
                            long y = b7 >>> 56;
                            b7 = b6 >>> 56 | b7 << 8;
                            b6 = b5 >>> 56 | b6 << 8;
                            b5 = b4 >>> 56 | b5 << 8;
                            b4 = b3 >>> 56 | b4 << 8;
                            b3 = b2 >>> 56 | b3 << 8;
                            b2 = b1 >>> 56 | b2 << 8;
                            b1 = b0 >>> 56 | b1 << 8;
                            b0 = z | b0 << 8;
                            z = y;
                            this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
                            off += 32;
                        } while ((remainingChars -= 32) >= 32);
                        this.buffer[0] = (byte)z;
                    }
                }
            }
            ByteArrayUtil.copyCharsToByteArray(s, off, this.buffer, offset, remainingChars);
            return this;
        }

        private void processBuffer() {
            long b0 = ByteArrayUtil.getLong(this.buffer, 0);
            long b1 = ByteArrayUtil.getLong(this.buffer, 8);
            long b2 = ByteArrayUtil.getLong(this.buffer, 16);
            long b3 = ByteArrayUtil.getLong(this.buffer, 24);
            long b4 = ByteArrayUtil.getLong(this.buffer, 32);
            long b5 = ByteArrayUtil.getLong(this.buffer, 40);
            long b6 = ByteArrayUtil.getLong(this.buffer, 48);
            long b7 = ByteArrayUtil.getLong(this.buffer, 56);
            this.processBuffer(b0, b1, b2, b3, b4, b5, b6, b7);
        }

        protected abstract void processBuffer(long var1, long var3, long var5, long var7, long var9, long var11, long var13, long var15);

        protected abstract long finalizeGetAsLong(long var1, long var3, int var5, int var6);

        @Override
        public long getAsLong() {
            long r1h;
            long r1l;
            long tmp2;
            long tmp1;
            long se5 = this.see5;
            long se1 = this.see1;
            if (this.byteCount > 63L) {
                se5 ^= this.see6 ^ this.see7 ^ this.see8;
                se1 ^= this.see2 ^ this.see3 ^ this.see4;
            }
            int len = (int)(this.byteCount & 0x3FL);
            int off = 0;
            if (len > 31) {
                tmp1 = se1 ^ ByteArrayUtil.getLong(this.buffer, off);
                tmp2 = se5 ^ ByteArrayUtil.getLong(this.buffer, off + 8);
                r1l = tmp1 * tmp2;
                r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2);
                se1 = (se5 += r1h) ^ r1l;
                long tmp3 = se1 ^ ByteArrayUtil.getLong(this.buffer, off + 16);
                long tmp4 = se5 ^ ByteArrayUtil.getLong(this.buffer, off + 24);
                r1l = tmp3 * tmp4;
                r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp3, tmp4);
                se1 = (se5 += r1h) ^ r1l;
                off += 32;
                len -= 32;
            }
            if (len > 15) {
                tmp1 = se1 ^ ByteArrayUtil.getLong(this.buffer, off);
                tmp2 = se5 ^ ByteArrayUtil.getLong(this.buffer, off + 8);
                r1l = tmp1 * tmp2;
                r1h = UnsignedMultiplyUtil.unsignedMultiplyHigh(tmp1, tmp2);
                se1 = (se5 += r1h) ^ r1l;
                off += 16;
                len -= 16;
            }
            return this.finalizeGetAsLong(se1, se5, off, len);
        }

        protected void copyTo(HashStreamImpl hashStream) {
            hashStream.see1 = this.see1;
            hashStream.see2 = this.see2;
            hashStream.see3 = this.see3;
            hashStream.see4 = this.see4;
            hashStream.see5 = this.see5;
            hashStream.see6 = this.see6;
            hashStream.see7 = this.see7;
            hashStream.see8 = this.see8;
            hashStream.byteCount = this.byteCount;
            System.arraycopy(this.buffer, 0, hashStream.buffer, 0, this.buffer.length);
        }
    }
}

