/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.fixes;

import com.intellij.json.JsonBundle;
import com.intellij.json.psi.JsonObject;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.JsonSchemaQuickFixSuppressor;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.fixes.AddMissingPropertyFix;
import com.jetbrains.jsonSchema.impl.fixes.JsonSchemaPropertiesInfo;
import com.jetbrains.jsonSchema.impl.fixes.missingOptionalPropertiesSearch;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0005\u001a\u00130\u0006\u00a2\u0006\u000e\b\u0007\u0012\n\b\b\u0012\u0006\b\n0\t8\nH\u0016J\u0019\u0010\u000b\u001a\u00130\u0006\u00a2\u0006\u000e\b\u0007\u0012\n\b\b\u0012\u0006\b\n0\t8\nH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J!\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0094\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/jsonSchema/impl/fixes/AddOptionalPropertiesIntention;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/intellij/psi/PsiElement;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Sentence", "getText", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getSyntaxAdapter", "Lcom/jetbrains/jsonSchema/extension/JsonLikeSyntaxAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "findPhysicalObjectNode", "findContainingObjectNode", "intellij.json.backend"})
@SourceDebugExtension(value={"SMAP\nAddOptionalPropertiesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddOptionalPropertiesIntention.kt\ncom/jetbrains/jsonSchema/impl/fixes/AddOptionalPropertiesIntention\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1761#2,3:71\n*S KotlinDebug\n*F\n+ 1 AddOptionalPropertiesIntention.kt\ncom/jetbrains/jsonSchema/impl/fixes/AddOptionalPropertiesIntention\n*L\n34#1:71,3\n*E\n"})
public class AddOptionalPropertiesIntention
extends PsiUpdateModCommandAction<PsiElement> {
    public AddOptionalPropertiesIntention() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = JsonBundle.message((String)"intention.add.not.required.properties.family.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @TestOnly
    @NotNull
    public final String getText() {
        String string = JsonBundle.message((String)"intention.add.not.required.properties.text", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        JsonValidationError.MissingMultiplePropsIssueData missing;
        boolean bl;
        PsiElement obj;
        block7: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiElement psiElement = this.findContainingObjectNode(context, element);
            if (psiElement == null) {
                return null;
            }
            obj = psiElement;
            Iterable $this$any$iv = JsonSchemaQuickFixSuppressor.Companion.getEXTENSION_POINT_NAME().getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    JsonSchemaQuickFixSuppressor it = (JsonSchemaQuickFixSuppressor)element$iv;
                    boolean bl2 = false;
                    PsiFile psiFile = context.file();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file(...)");
                    if (!it.shouldSuppressFix(psiFile, AddOptionalPropertiesIntention.class)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return null;
        }
        if (!JsonCachedValues.hasComputedSchemaObjectForFile(obj.getContainingFile())) {
            return null;
        }
        SmartPsiElementPointer smartPsiElementPointer = SmartPointersKt.createSmartPointer((PsiElement)obj);
        Project project = context.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        JsonSchemaPropertiesInfo jsonSchemaPropertiesInfo = missingOptionalPropertiesSearch.collectMissingPropertiesFromSchema((SmartPsiElementPointer<? extends PsiElement>)smartPsiElementPointer, project);
        JsonValidationError.MissingMultiplePropsIssueData missingMultiplePropsIssueData = missing = jsonSchemaPropertiesInfo != null ? jsonSchemaPropertiesInfo.getMissingKnownProperties() : null;
        if (missing == null || missing.myMissingPropertyIssues.isEmpty()) {
            return null;
        }
        return Presentation.of((String)JsonBundle.message((String)"intention.add.not.required.properties.text", (Object[])new Object[0]));
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PsiElement psiElement = this.findContainingObjectNode(context, element);
        if (psiElement == null) {
            return;
        }
        PsiElement objCopy = psiElement;
        PsiElement psiElement2 = this.findPhysicalObjectNode(context, element);
        if (psiElement2 == null) {
            return;
        }
        PsiElement physObj = psiElement2;
        SmartPsiElementPointer smartPsiElementPointer = SmartPointersKt.createSmartPointer((PsiElement)physObj);
        Project project = context.project();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project(...)");
        Object object = missingOptionalPropertiesSearch.collectMissingPropertiesFromSchema((SmartPsiElementPointer<? extends PsiElement>)smartPsiElementPointer, project);
        if (object == null || (object = ((JsonSchemaPropertiesInfo)object).getMissingKnownProperties()) == null) {
            return;
        }
        Object missing = object;
        Project project2 = context.project();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project(...)");
        new AddMissingPropertyFix((JsonValidationError.MissingMultiplePropsIssueData)missing, this.getSyntaxAdapter(project2)).performFixInner(objCopy, (Ref<PsiElement>)Ref.create());
        CodeStyleManager.getInstance((Project)context.project()).reformatText(objCopy.getContainingFile(), (Collection)SetsKt.setOf((Object)objCopy.getTextRange()));
    }

    @NotNull
    protected JsonLikeSyntaxAdapter getSyntaxAdapter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        JsonLikeSyntaxAdapter jsonLikeSyntaxAdapter = JsonOriginalPsiWalker.INSTANCE.getSyntaxAdapter(project);
        Intrinsics.checkNotNullExpressionValue((Object)jsonLikeSyntaxAdapter, (String)"getSyntaxAdapter(...)");
        return jsonLikeSyntaxAdapter;
    }

    @Nullable
    protected PsiElement findPhysicalObjectNode(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = context.findLeaf();
        if (psiElement == null) {
            return null;
        }
        PsiElement physLeaf = psiElement;
        return PsiTreeUtil.getParentOfType((PsiElement)physLeaf, JsonObject.class);
    }

    @Nullable
    protected PsiElement findContainingObjectNode(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        JsonObject jsonObject = (JsonObject)PsiTreeUtil.getParentOfType((PsiElement)element, JsonObject.class);
        return jsonObject != null ? (PsiElement)jsonObject : PsiTreeUtil.getParentOfType((PsiElement)context.findLeaf(), JsonObject.class);
    }
}

