/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import org.assertj.core.util.Preconditions;

public final class Percentage {
    public final double value;

    public static Percentage withPercentage(double value) {
        Preconditions.checkArgument(value >= 0.0, "The percentage value <%s> should be greater than or equal to zero", value);
        return new Percentage(value);
    }

    private Percentage(double value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Percentage)) {
            return false;
        }
        Percentage other = (Percentage)obj;
        return Double.compare(this.value, other.value) == 0;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    public String toString() {
        return this.noFractionalPart() ? "%s%%".formatted((int)this.value) : "%s%%".formatted(this.value);
    }

    private boolean noFractionalPart() {
        return this.value % 1.0 == 0.0;
    }
}

