/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.collectors.CounterContainer;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.SSAConstructorSparseEx;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarTypeProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersion;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;

public class VarVersionsProcessor {
    private final StructMethod method;
    private Map<Integer, VarVersion> mapOriginalVarIndices = Collections.emptyMap();
    private final VarTypeProcessor typeProcessor;

    public VarVersionsProcessor(StructMethod mt, MethodDescriptor md) {
        this.method = mt;
        this.typeProcessor = new VarTypeProcessor(mt, md);
    }

    public void setVarVersions(RootStatement root, VarVersionsProcessor previousVersionsProcessor) {
        SSAConstructorSparseEx ssa = new SSAConstructorSparseEx();
        ssa.splitVariables(root, this.method);
        FlattenStatementsHelper flattenHelper = new FlattenStatementsHelper();
        DirectGraph graph = flattenHelper.buildDirectGraph(root);
        DotExporter.toDotFile(graph, this.method, "setVarVersions");
        VarVersionsProcessor.mergePhiVersions(ssa, graph);
        this.typeProcessor.calculateVarTypes(root, graph);
        VarVersionsProcessor.eliminateNonJavaTypes(this.typeProcessor);
        this.setNewVarIndices(this.typeProcessor, graph, previousVersionsProcessor);
    }

    private static void mergePhiVersions(SSAConstructorSparseEx ssa, DirectGraph graph) {
        ArrayList<Set<VarVersion>> lst = new ArrayList<Set<VarVersion>>();
        for (Map.Entry<VarVersion, FastSparseSetFactory.FastSparseSet<Integer>> ent : ssa.getPhi().entrySet()) {
            Set<VarVersion> set = new HashSet<VarVersion>();
            set.add(ent.getKey());
            for (Integer version : ent.getValue()) {
                set.add(new VarVersion(ent.getKey().var, (int)version));
            }
            for (int i = lst.size() - 1; i >= 0; --i) {
                Set tset = (Set)lst.get(i);
                HashSet intersection = new HashSet(set);
                intersection.retainAll(tset);
                if (intersection.isEmpty()) continue;
                set.addAll(tset);
                lst.remove(i);
            }
            lst.add(set);
        }
        HashMap<VarVersion, Integer> phiVersions = new HashMap<VarVersion, Integer>();
        for (Set<VarVersion> set : lst) {
            int min = Integer.MAX_VALUE;
            for (VarVersion paar : set) {
                if (paar.version >= min) continue;
                min = paar.version;
            }
            for (VarVersion paar : set) {
                phiVersions.put(new VarVersion(paar.var, paar.version), min);
            }
        }
        VarVersionsProcessor.updateVersions(graph, phiVersions);
    }

    private static void updateVersions(DirectGraph graph, Map<VarVersion, Integer> versions) {
        graph.iterateExprents(exprent -> {
            List<Exprent> lst = exprent.getAllExprents(true);
            lst.add(exprent);
            for (Exprent expr : lst) {
                VarExprent var;
                Integer version;
                if (expr.type != 12 || (version = (Integer)versions.get(new VarVersion(var = (VarExprent)expr))) == null) continue;
                var.setVersion(version);
            }
            return 0;
        });
    }

    private static void eliminateNonJavaTypes(VarTypeProcessor typeProcessor) {
        Map<VarVersion, VarType> mapExprentMaxTypes = typeProcessor.getMaxExprentTypes();
        Map<VarVersion, VarType> mapExprentMinTypes = typeProcessor.getMinExprentTypes();
        for (VarVersion paar : new ArrayList<VarVersion>(mapExprentMinTypes.keySet())) {
            VarType type = mapExprentMinTypes.get(paar);
            VarType maxType = mapExprentMaxTypes.get(paar);
            if (type.getType() == 15 || type.getType() == 16) {
                type = maxType != null && maxType.getType() == 1 ? VarType.VARTYPE_CHAR : (type.getType() == 15 ? VarType.VARTYPE_BYTE : VarType.VARTYPE_SHORT);
                mapExprentMinTypes.put(paar, type);
                continue;
            }
            if (type.getType() != 13) continue;
            mapExprentMinTypes.put(paar, VarType.VARTYPE_OBJECT);
        }
    }

    private static void simpleMerge(VarTypeProcessor typeProcessor, DirectGraph graph, StructMethod mt) {
        Map<VarVersion, VarType> mapExprentMaxTypes = typeProcessor.getMaxExprentTypes();
        Map<VarVersion, VarType> mapExprentMinTypes = typeProcessor.getMinExprentTypes();
        HashMap<Integer, Set> mapVarVersions = new HashMap<Integer, Set>();
        for (VarVersion pair : mapExprentMinTypes.keySet()) {
            if (pair.version < 0) continue;
            mapVarVersions.computeIfAbsent(pair.var, k -> new HashSet()).add(pair.version);
        }
        boolean is_method_static = mt.hasModifier(8);
        HashMap<VarVersion, Integer> mapMergedVersions = new HashMap<VarVersion, Integer>();
        for (Map.Entry ent : mapVarVersions.entrySet()) {
            if (((Set)ent.getValue()).size() <= 1) continue;
            ArrayList lstVersions = new ArrayList((Collection)ent.getValue());
            Collections.sort(lstVersions);
            for (int i = 0; i < lstVersions.size(); ++i) {
                VarVersion firstPair = new VarVersion((Integer)ent.getKey(), (Integer)lstVersions.get(i));
                VarType firstType = mapExprentMinTypes.get(firstPair);
                if (firstPair.var == 0 && firstPair.version == 1 && !is_method_static) continue;
                for (int j = i + 1; j < lstVersions.size(); ++j) {
                    VarType type;
                    VarVersion secondPair = new VarVersion((Integer)ent.getKey(), (Integer)lstVersions.get(j));
                    VarType secondType = mapExprentMinTypes.get(secondPair);
                    if (!(firstType.equals(secondType) || firstType.equals(VarType.VARTYPE_NULL) && secondType.getType() == 8 || secondType.equals(VarType.VARTYPE_NULL) && firstType.getType() == 8) && (firstType.getTypeFamily() != 2 || secondType.getTypeFamily() != 2)) continue;
                    VarType firstMaxType = mapExprentMaxTypes.get(firstPair);
                    VarType secondMaxType = mapExprentMaxTypes.get(secondPair);
                    VarType varType = firstMaxType == null ? secondMaxType : (type = secondMaxType == null ? firstMaxType : VarType.getCommonMinType(firstMaxType, secondMaxType));
                    if (firstType.getTypeFamily() == 2 && secondType.getTypeFamily() == 2) {
                        block0 : switch (secondType.getType()) {
                            case 4: {
                                VarType varType2 = VarType.VARTYPE_INT;
                                break;
                            }
                            case 6: {
                                VarType varType2;
                                if (firstType.getType() == 4) {
                                    varType2 = null;
                                    break;
                                }
                                varType2 = VarType.VARTYPE_SHORT;
                                break;
                            }
                            case 1: {
                                VarType varType2;
                                switch (firstType.getType()) {
                                    case 4: 
                                    case 6: {
                                        varType2 = null;
                                        break block0;
                                    }
                                }
                                varType2 = VarType.VARTYPE_CHAR;
                                break;
                            }
                            case 16: {
                                VarType varType2;
                                switch (firstType.getType()) {
                                    case 1: 
                                    case 4: 
                                    case 6: {
                                        varType2 = null;
                                        break block0;
                                    }
                                }
                                varType2 = VarType.VARTYPE_SHORTCHAR;
                                break;
                            }
                            case 15: {
                                VarType varType2;
                                switch (firstType.getType()) {
                                    case 1: 
                                    case 4: 
                                    case 6: 
                                    case 16: {
                                        varType2 = null;
                                        break block0;
                                    }
                                }
                                varType2 = VarType.VARTYPE_BYTECHAR;
                                break;
                            }
                            case 0: {
                                VarType varType2;
                                switch (firstType.getType()) {
                                    case 1: 
                                    case 4: 
                                    case 6: 
                                    case 15: 
                                    case 16: {
                                        varType2 = null;
                                        break block0;
                                    }
                                }
                                varType2 = VarType.VARTYPE_BYTE;
                                break;
                            }
                            default: {
                                VarType varType2 = type = type;
                            }
                        }
                        if (type == null) continue;
                        firstType = type;
                        mapExprentMinTypes.put(firstPair, type);
                    }
                    mapExprentMaxTypes.put(firstPair, type);
                    mapMergedVersions.put(secondPair, firstPair.version);
                    mapExprentMaxTypes.remove(secondPair);
                    mapExprentMinTypes.remove(secondPair);
                    if (firstType.equals(VarType.VARTYPE_NULL)) {
                        mapExprentMinTypes.put(firstPair, secondType);
                        firstType = secondType;
                    }
                    typeProcessor.getFinalVariables().put(firstPair, 1);
                    lstVersions.remove(j);
                    --j;
                }
            }
        }
        if (!mapMergedVersions.isEmpty()) {
            VarVersionsProcessor.updateVersions(graph, mapMergedVersions);
        }
    }

    private void setNewVarIndices(VarTypeProcessor typeProcessor, DirectGraph graph, VarVersionsProcessor previousVersionsProcessor) {
        Map<VarVersion, VarType> mapExprentMaxTypes = typeProcessor.getMaxExprentTypes();
        Map<VarVersion, VarType> mapExprentMinTypes = typeProcessor.getMinExprentTypes();
        Map<VarVersion, Integer> mapFinalVars = typeProcessor.getFinalVariables();
        CounterContainer counters = DecompilerContext.getCounterContainer();
        HashMap<VarVersion, Integer> mapVarPaar = new HashMap<VarVersion, Integer>();
        HashMap<Integer, VarVersion> mapOriginalVarIndices = new HashMap<Integer, VarVersion>();
        mapOriginalVarIndices.putAll(this.mapOriginalVarIndices);
        ArrayList<VarVersion> vvps = new ArrayList<VarVersion>(mapExprentMinTypes.keySet());
        Collections.sort(vvps);
        for (VarVersion pair : vvps) {
            if (pair.version < 0) continue;
            int newIndex = pair.version == 1 ? pair.var : counters.getCounterAndIncrement(2);
            VarVersion newVar = new VarVersion(newIndex, 0);
            mapExprentMinTypes.put(newVar, mapExprentMinTypes.get(pair));
            mapExprentMaxTypes.put(newVar, mapExprentMaxTypes.get(pair));
            if (mapFinalVars.containsKey(pair)) {
                mapFinalVars.put(newVar, mapFinalVars.remove(pair));
            }
            mapVarPaar.put(pair, newIndex);
            mapOriginalVarIndices.put(newIndex, pair);
        }
        graph.iterateExprents(exprent -> {
            List<Exprent> lst = exprent.getAllExprents(true);
            lst.add(exprent);
            for (Exprent expr : lst) {
                VarType maxType;
                if (expr.type == 12) {
                    VarExprent newVar = (VarExprent)expr;
                    Integer newVarIndex = (Integer)mapVarPaar.get(new VarVersion(newVar));
                    if (newVarIndex == null) continue;
                    String name = newVar.getProcessor().getAssignedVarName(new VarVersion(newVar.getIndex(), 0));
                    newVar.setIndex(newVarIndex);
                    newVar.setVersion(0);
                    if (name == null || newVar.getLVTEntry() != null || newVar.getProcessor().getVarName(newVar.getVarVersion()) != null) continue;
                    newVar.getProcessor().setAssignedVarName(newVar.getVarVersion(), name);
                    newVar.getProcessor().setVarName(newVar.getVarVersion(), name);
                    continue;
                }
                if (expr.type != 3 || (maxType = (VarType)mapExprentMaxTypes.get(new VarVersion(expr.id, -1))) == null || !maxType.equals(VarType.VARTYPE_CHAR)) continue;
                ((ConstExprent)expr).setConstType(maxType);
            }
            return 0;
        });
        if (previousVersionsProcessor != null) {
            Map<Integer, VarVersion> oldIndices = previousVersionsProcessor.getMapOriginalVarIndices();
            this.mapOriginalVarIndices = new HashMap<Integer, VarVersion>(mapOriginalVarIndices.size());
            for (Map.Entry entry : mapOriginalVarIndices.entrySet()) {
                VarVersion value = (VarVersion)entry.getValue();
                VarVersion oldValue = oldIndices.get(value.var);
                value = oldValue != null ? oldValue : value;
                this.mapOriginalVarIndices.put((Integer)entry.getKey(), value);
            }
        } else {
            this.mapOriginalVarIndices = mapOriginalVarIndices;
        }
    }

    public VarType getVarType(VarVersion pair) {
        return this.typeProcessor.getVarType(pair);
    }

    public void setVarType(VarVersion pair, VarType type) {
        this.typeProcessor.setVarType(pair, type);
    }

    public int getVarFinal(VarVersion pair) {
        Integer fin = this.typeProcessor.getFinalVariables().get(pair);
        return fin == null ? 3 : fin;
    }

    public void setVarFinal(VarVersion pair, int finalType) {
        this.typeProcessor.getFinalVariables().put(pair, finalType);
    }

    public Map<Integer, VarVersion> getMapOriginalVarIndices() {
        return this.mapOriginalVarIndices;
    }

    public VarTypeProcessor getTypeProcessor() {
        return this.typeProcessor;
    }
}

