/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.model.Model;
import org.apache.maven.repository.internal.MavenWorkspaceReader;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenWorkspaceMap;
import org.jetbrains.idea.maven.model.MavenWorkspaceMapWrapper;

public class Maven3WorkspaceMapReader
implements MavenWorkspaceReader {
    private final WorkspaceRepository myRepository = new WorkspaceRepository();
    private final MavenWorkspaceMapWrapper myWorkspaceMap;
    private final Map<MavenId, Model> myMavenModelMap = new HashMap<MavenId, Model>();

    public Maven3WorkspaceMapReader(MavenWorkspaceMap workspaceMap, Properties systemProperties) {
        this.myWorkspaceMap = new MavenWorkspaceMapWrapper(workspaceMap, systemProperties);
    }

    public WorkspaceRepository getRepository() {
        return this.myRepository;
    }

    public File findArtifact(Artifact artifact) {
        MavenWorkspaceMap.Data resolved = this.myWorkspaceMap.findFileAndOriginalId(new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        if (resolved == null) {
            return null;
        }
        return resolved.getFile(artifact.getExtension());
    }

    public List<String> findVersions(Artifact artifact) {
        ArrayList<String> res = new ArrayList<String>();
        Set ids = this.myWorkspaceMap.getAvailableIdsForArtifactId(artifact.getArtifactId());
        for (MavenId id : ids) {
            String version;
            if (!Objects.equals(id.getGroupId(), artifact.getGroupId()) || (version = id.getVersion()) == null) continue;
            res.add(version);
        }
        return res;
    }

    public Model findModel(Artifact artifact) {
        return this.myMavenModelMap.get(new MavenId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
    }

    public void fillSessionCache(Map<MavenId, Model> map) {
        this.myMavenModelMap.putAll(map);
        for (MavenId mavenId : map.keySet()) {
            File pomFile;
            Model model = map.get(mavenId);
            if (null == model || null == (pomFile = model.getPomFile())) continue;
            this.myWorkspaceMap.register(mavenId, pomFile);
        }
    }
}

